<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Gebietstyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Der Typ des Gebiets bestimmt die Art des Gebiets näher. Bei verwaltungspolitischen Gebieten kann dies zum Beispiel Gemeinde, Landkreis oder Verbandsgemeinde sein.
 * @subpackage Structs
 */
class Gebietstyp extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The klasse
     * Meta information extracted from the WSDL
     * - documentation: Zuordnung einer Gebietsklasse.
     * @var \StructType\Gebietsklasse
     */
    public $klasse;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnungs des Gebietstyps.
     * - maxOccurs: unbounded
     * @var \StructType\String_Localized[]
     */
    public $bezeichnung;
    /**
     * The kurzbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Eine kurze prägnante Bezeichnung des Gebietstyps. Kann für Abkürzungen verwendet werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $kurzbezeichnung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Eine textuelle Beschreibung des Gebietstyps.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * Constructor method for Gebietstyp
     * @uses Gebietstyp::setId()
     * @uses Gebietstyp::setIdSekundaer()
     * @uses Gebietstyp::setKlasse()
     * @uses Gebietstyp::setBezeichnung()
     * @uses Gebietstyp::setKurzbezeichnung()
     * @uses Gebietstyp::setBeschreibung()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\Gebietsklasse $klasse
     * @param \StructType\String_Localized[] $bezeichnung
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @param \StructType\String_Localized[] $beschreibung
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), \StructType\Gebietsklasse $klasse = null, array $bezeichnung = array(), array $kurzbezeichnung = array(), array $beschreibung = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setKlasse($klasse)
            ->setBezeichnung($bezeichnung)
            ->setKurzbezeichnung($kurzbezeichnung)
            ->setBeschreibung($beschreibung);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Gebietstyp
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietstypIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$gebietstypIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($gebietstypIdSekundaerItem) ? get_class($gebietstypIdSekundaerItem) : sprintf('%s(%s)', gettype($gebietstypIdSekundaerItem), var_export($gebietstypIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Gebietstyp
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Gebietstyp
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get klasse value
     * @return \StructType\Gebietsklasse|null
     */
    public function getKlasse()
    {
        return $this->klasse;
    }
    /**
     * Set klasse value
     * @param \StructType\Gebietsklasse $klasse
     * @return \StructType\Gebietstyp
     */
    public function setKlasse(\StructType\Gebietsklasse $klasse = null)
    {
        $this->klasse = $klasse;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietstypBezeichnungItem) {
            // validation for constraint: itemType
            if (!$gebietstypBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($gebietstypBezeichnungItem) ? get_class($gebietstypBezeichnungItem) : sprintf('%s(%s)', gettype($gebietstypBezeichnungItem), var_export($gebietstypBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $bezeichnung
     * @return \StructType\Gebietstyp
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Gebietstyp
     */
    public function addToBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietstypKurzbezeichnungItem) {
            // validation for constraint: itemType
            if (!$gebietstypKurzbezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($gebietstypKurzbezeichnungItem) ? get_class($gebietstypKurzbezeichnungItem) : sprintf('%s(%s)', gettype($gebietstypKurzbezeichnungItem), var_export($gebietstypKurzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @return \StructType\Gebietstyp
     */
    public function setKurzbezeichnung(array $kurzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungArrayErrorMessage = self::validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung($kurzbezeichnung))) {
            throw new \InvalidArgumentException($kurzbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Add item to kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Gebietstyp
     */
    public function addToKurzbezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnung[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietstypBeschreibungItem) {
            // validation for constraint: itemType
            if (!$gebietstypBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($gebietstypBeschreibungItem) ? get_class($gebietstypBeschreibungItem) : sprintf('%s(%s)', gettype($gebietstypBeschreibungItem), var_export($gebietstypBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Gebietstyp
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Gebietstyp
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
}
