<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fristmodul StructType
 * Meta information extracted from the WSDL
 * - documentation: Modul zur Abbildung von Fristen zu Leistungen.
 * @subpackage Structs
 */
class Fristmodul extends Leistungsmodul
{
    /**
     * The frist
     * Meta information extracted from the WSDL
     * - documentation: Strukturiert erfasste Fristen zur Leistung
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FristMitTyp[]
     */
    public $frist;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine (textuelle) Beschreibung des Fristmoduls. Es soll angestrebt werden, die konkreten Fristen unter "frist" als strukturierte Daten anzugeben.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier
     * gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The weiterfuehrenderLink
     * Meta information extracted from the WSDL
     * - documentation: Angabe von weiterführenden Links.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $weiterfuehrenderLink;
    /**
     * Constructor method for Fristmodul
     * @uses Fristmodul::setFrist()
     * @uses Fristmodul::setBeschreibung()
     * @uses Fristmodul::setWeiterfuehrenderLink()
     * @param \StructType\FristMitTyp[] $frist
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     */
    public function __construct(array $frist = array(), array $beschreibung = array(), array $weiterfuehrenderLink = array())
    {
        $this
            ->setFrist($frist)
            ->setBeschreibung($beschreibung)
            ->setWeiterfuehrenderLink($weiterfuehrenderLink);
    }
    /**
     * Get frist value
     * @return \StructType\FristMitTyp[]|null
     */
    public function getFrist()
    {
        return $this->frist;
    }
    /**
     * This method is responsible for validating the values passed to the setFrist method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFrist method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFristForArrayConstraintsFromSetFrist(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fristmodulFristItem) {
            // validation for constraint: itemType
            if (!$fristmodulFristItem instanceof \StructType\FristMitTyp) {
                $invalidValues[] = is_object($fristmodulFristItem) ? get_class($fristmodulFristItem) : sprintf('%s(%s)', gettype($fristmodulFristItem), var_export($fristmodulFristItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The frist property can only contain items of type \StructType\FristMitTyp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set frist value
     * @throws \InvalidArgumentException
     * @param \StructType\FristMitTyp[] $frist
     * @return \StructType\Fristmodul
     */
    public function setFrist(array $frist = array())
    {
        // validation for constraint: array
        if ('' !== ($fristArrayErrorMessage = self::validateFristForArrayConstraintsFromSetFrist($frist))) {
            throw new \InvalidArgumentException($fristArrayErrorMessage, __LINE__);
        }
        $this->frist = $frist;
        return $this;
    }
    /**
     * Add item to frist value
     * @throws \InvalidArgumentException
     * @param \StructType\FristMitTyp $item
     * @return \StructType\Fristmodul
     */
    public function addToFrist(\StructType\FristMitTyp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FristMitTyp) {
            throw new \InvalidArgumentException(sprintf('The frist property can only contain items of type \StructType\FristMitTyp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->frist[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fristmodulBeschreibungItem) {
            // validation for constraint: itemType
            if (!$fristmodulBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($fristmodulBeschreibungItem) ? get_class($fristmodulBeschreibungItem) : sprintf('%s(%s)', gettype($fristmodulBeschreibungItem), var_export($fristmodulBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Fristmodul
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Fristmodul
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get weiterfuehrenderLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getWeiterfuehrenderLink()
    {
        return $this->weiterfuehrenderLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWeiterfuehrenderLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeiterfuehrenderLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fristmodulWeiterfuehrenderLinkItem) {
            // validation for constraint: itemType
            if (!$fristmodulWeiterfuehrenderLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($fristmodulWeiterfuehrenderLinkItem) ? get_class($fristmodulWeiterfuehrenderLinkItem) : sprintf('%s(%s)', gettype($fristmodulWeiterfuehrenderLinkItem), var_export($fristmodulWeiterfuehrenderLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     * @return \StructType\Fristmodul
     */
    public function setWeiterfuehrenderLink(array $weiterfuehrenderLink = array())
    {
        // validation for constraint: array
        if ('' !== ($weiterfuehrenderLinkArrayErrorMessage = self::validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink($weiterfuehrenderLink))) {
            throw new \InvalidArgumentException($weiterfuehrenderLinkArrayErrorMessage, __LINE__);
        }
        $this->weiterfuehrenderLink = $weiterfuehrenderLink;
        return $this;
    }
    /**
     * Add item to weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Fristmodul
     */
    public function addToWeiterfuehrenderLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weiterfuehrenderLink[] = $item;
        return $this;
    }
}
