<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FristOhneTyp StructType
 * Meta information extracted from the WSDL
 * - documentation: Frist ohne Typ zur Verwendung im Bearbeitungsdauermodul von Leistungen.
 * @subpackage Structs
 */
class FristOhneTyp extends AbstractStructBase
{
    /**
     * The fristauswahl
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Frist, entweder Dauer oder Stichtag.
     * @var \StructType\FristAuswahl
     */
    public $fristauswahl;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Erläuterungen zur Frist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The positionDarstellung
     * Meta information extracted from the WSDL
     * - documentation: Position in der Darstellung aller Fristen im Modul.
     * - minOccurs: 0
     * @var int
     */
    public $positionDarstellung;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for FristOhneTyp
     * @uses FristOhneTyp::setFristauswahl()
     * @uses FristOhneTyp::setBeschreibung()
     * @uses FristOhneTyp::setPositionDarstellung()
     * @uses FristOhneTyp::setGueltigkeit()
     * @param \StructType\FristAuswahl $fristauswahl
     * @param \StructType\String_Localized[] $beschreibung
     * @param int $positionDarstellung
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\FristAuswahl $fristauswahl = null, array $beschreibung = array(), $positionDarstellung = null, array $gueltigkeit = array())
    {
        $this
            ->setFristauswahl($fristauswahl)
            ->setBeschreibung($beschreibung)
            ->setPositionDarstellung($positionDarstellung)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get fristauswahl value
     * @return \StructType\FristAuswahl|null
     */
    public function getFristauswahl()
    {
        return $this->fristauswahl;
    }
    /**
     * Set fristauswahl value
     * @param \StructType\FristAuswahl $fristauswahl
     * @return \StructType\FristOhneTyp
     */
    public function setFristauswahl(\StructType\FristAuswahl $fristauswahl = null)
    {
        $this->fristauswahl = $fristauswahl;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fristOhneTypBeschreibungItem) {
            // validation for constraint: itemType
            if (!$fristOhneTypBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($fristOhneTypBeschreibungItem) ? get_class($fristOhneTypBeschreibungItem) : sprintf('%s(%s)', gettype($fristOhneTypBeschreibungItem), var_export($fristOhneTypBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\FristOhneTyp
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\FristOhneTyp
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get positionDarstellung value
     * @return int|null
     */
    public function getPositionDarstellung()
    {
        return $this->positionDarstellung;
    }
    /**
     * Set positionDarstellung value
     * @param int $positionDarstellung
     * @return \StructType\FristOhneTyp
     */
    public function setPositionDarstellung($positionDarstellung = null)
    {
        // validation for constraint: int
        if (!is_null($positionDarstellung) && !(is_int($positionDarstellung) || ctype_digit($positionDarstellung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionDarstellung, true), gettype($positionDarstellung)), __LINE__);
        }
        $this->positionDarstellung = $positionDarstellung;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fristOhneTypGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$fristOhneTypGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($fristOhneTypGueltigkeitItem) ? get_class($fristOhneTypGueltigkeitItem) : sprintf('%s(%s)', gettype($fristOhneTypGueltigkeitItem), var_export($fristOhneTypGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\FristOhneTyp
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\FristOhneTyp
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
