<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormulardateiLink StructType
 * Meta information extracted from the WSDL
 * - documentation: Hierüber kann ein Verweis (Hyperlink) auf eine Formulardatei übertragen werden. Implementiert den abstrakten Typ Formulardatei.
 * @subpackage Structs
 */
class FormulardateiLink extends Formulardatei
{
    /**
     * The uri
     * Meta information extracted from the WSDL
     * - documentation: URI des Formulardokuments.
     * @var string
     */
    public $uri;
    /**
     * The mimeCode
     * Meta information extracted from the WSDL
     * - documentation: MIME-Code des Formulardokuments, welches in uri angegeben wird.
     * - use: optional
     * @var string
     */
    public $mimeCode;
    /**
     * Constructor method for FormulardateiLink
     * @uses FormulardateiLink::setUri()
     * @uses FormulardateiLink::setMimeCode()
     * @param string $uri
     * @param string $mimeCode
     */
    public function __construct($uri = null, $mimeCode = null)
    {
        $this
            ->setUri($uri)
            ->setMimeCode($mimeCode);
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \StructType\FormulardateiLink
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uri, true), gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get mimeCode value
     * @return string|null
     */
    public function getMimeCode()
    {
        return $this->mimeCode;
    }
    /**
     * Set mimeCode value
     * @param string $mimeCode
     * @return \StructType\FormulardateiLink
     */
    public function setMimeCode($mimeCode = null)
    {
        // validation for constraint: string
        if (!is_null($mimeCode) && !is_string($mimeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeCode, true), gettype($mimeCode)), __LINE__);
        }
        $this->mimeCode = $mimeCode;
        return $this;
    }
}
