<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Formulardatei StructType
 * Meta information extracted from the WSDL
 * - documentation: Abstrakter Datentyp zur Abbildung einer Formulardatei. Eine Formulardatei ist ein konkretes elektronisches Dokument, wie z.B. ein Formular im PDF-Format.
 * @subpackage Structs
 */
abstract class Formulardatei extends AbstractStructBase
{
    /**
     * The formulardokumentTypZusatz
     * Meta information extracted from the WSDL
     * - documentation: Angaben zum Dateityp zum Formulardokument. Hier können Zusatzangaben zum Dokumentformat gemacht werden. Insbesondere wenn diese sich nicht mittels MIME-Type abbilden lassen. Beispiel: "PDF interaktiv", "Mobile Ansicht"
     * - minOccurs: 0
     * @var string
     */
    public $formulardokumentTypZusatz;
    /**
     * Constructor method for Formulardatei
     * @uses Formulardatei::setFormulardokumentTypZusatz()
     * @param string $formulardokumentTypZusatz
     */
    public function __construct($formulardokumentTypZusatz = null)
    {
        $this
            ->setFormulardokumentTypZusatz($formulardokumentTypZusatz);
    }
    /**
     * Get formulardokumentTypZusatz value
     * @return string|null
     */
    public function getFormulardokumentTypZusatz()
    {
        return $this->formulardokumentTypZusatz;
    }
    /**
     * Set formulardokumentTypZusatz value
     * @param string $formulardokumentTypZusatz
     * @return \StructType\Formulardatei
     */
    public function setFormulardokumentTypZusatz($formulardokumentTypZusatz = null)
    {
        // validation for constraint: string
        if (!is_null($formulardokumentTypZusatz) && !is_string($formulardokumentTypZusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formulardokumentTypZusatz, true), gettype($formulardokumentTypZusatz)), __LINE__);
        }
        $this->formulardokumentTypZusatz = $formulardokumentTypZusatz;
        return $this;
    }
}
