<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FaceType StructType
 * @subpackage Structs
 */
class FaceType extends AbstractStructBase
{
    /**
     * The isolated
     * @var \StructType\NodePropertyType
     */
    public $isolated;
    /**
     * The directedEdge
     * @var \StructType\DirectedEdgePropertyType
     */
    public $directedEdge;
    /**
     * The directedTopoSolid
     * @var \StructType\DirectedTopoSolidPropertyType
     */
    public $directedTopoSolid;
    /**
     * The surfaceProperty
     * @var \StructType\SurfacePropertyType
     */
    public $surfaceProperty;
    /**
     * The universal
     * @var bool
     */
    public $universal;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for FaceType
     * @uses FaceType::setIsolated()
     * @uses FaceType::setDirectedEdge()
     * @uses FaceType::setDirectedTopoSolid()
     * @uses FaceType::setSurfaceProperty()
     * @uses FaceType::setUniversal()
     * @uses FaceType::setAggregationType()
     * @param \StructType\NodePropertyType $isolated
     * @param \StructType\DirectedEdgePropertyType $directedEdge
     * @param \StructType\DirectedTopoSolidPropertyType $directedTopoSolid
     * @param \StructType\SurfacePropertyType $surfaceProperty
     * @param bool $universal
     * @param string $aggregationType
     */
    public function __construct(\StructType\NodePropertyType $isolated = null, \StructType\DirectedEdgePropertyType $directedEdge = null, \StructType\DirectedTopoSolidPropertyType $directedTopoSolid = null, \StructType\SurfacePropertyType $surfaceProperty = null, $universal = null, $aggregationType = null)
    {
        $this
            ->setIsolated($isolated)
            ->setDirectedEdge($directedEdge)
            ->setDirectedTopoSolid($directedTopoSolid)
            ->setSurfaceProperty($surfaceProperty)
            ->setUniversal($universal)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get isolated value
     * @return \StructType\NodePropertyType|null
     */
    public function getIsolated()
    {
        return $this->isolated;
    }
    /**
     * Set isolated value
     * @param \StructType\NodePropertyType $isolated
     * @return \StructType\FaceType
     */
    public function setIsolated(\StructType\NodePropertyType $isolated = null)
    {
        $this->isolated = $isolated;
        return $this;
    }
    /**
     * Get directedEdge value
     * @return \StructType\DirectedEdgePropertyType|null
     */
    public function getDirectedEdge()
    {
        return $this->directedEdge;
    }
    /**
     * Set directedEdge value
     * @param \StructType\DirectedEdgePropertyType $directedEdge
     * @return \StructType\FaceType
     */
    public function setDirectedEdge(\StructType\DirectedEdgePropertyType $directedEdge = null)
    {
        $this->directedEdge = $directedEdge;
        return $this;
    }
    /**
     * Get directedTopoSolid value
     * @return \StructType\DirectedTopoSolidPropertyType|null
     */
    public function getDirectedTopoSolid()
    {
        return $this->directedTopoSolid;
    }
    /**
     * Set directedTopoSolid value
     * @param \StructType\DirectedTopoSolidPropertyType $directedTopoSolid
     * @return \StructType\FaceType
     */
    public function setDirectedTopoSolid(\StructType\DirectedTopoSolidPropertyType $directedTopoSolid = null)
    {
        $this->directedTopoSolid = $directedTopoSolid;
        return $this;
    }
    /**
     * Get surfaceProperty value
     * @return \StructType\SurfacePropertyType|null
     */
    public function getSurfaceProperty()
    {
        return $this->surfaceProperty;
    }
    /**
     * Set surfaceProperty value
     * @param \StructType\SurfacePropertyType $surfaceProperty
     * @return \StructType\FaceType
     */
    public function setSurfaceProperty(\StructType\SurfacePropertyType $surfaceProperty = null)
    {
        $this->surfaceProperty = $surfaceProperty;
        return $this;
    }
    /**
     * Get universal value
     * @return bool|null
     */
    public function getUniversal()
    {
        return $this->universal;
    }
    /**
     * Set universal value
     * @param bool $universal
     * @return \StructType\FaceType
     */
    public function setUniversal($universal = null)
    {
        // validation for constraint: boolean
        if (!is_null($universal) && !is_bool($universal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($universal, true), gettype($universal)), __LINE__);
        }
        $this->universal = $universal;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\FaceType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
