<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Erreichbarkeit StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp für Angaben zu Kommunikationskanälen für die Erreichbarkeit, wie Telefon, Fax, E-Mail. Die referenzierte Codeliste "Erreichbarkeit" aus dem XRepository bietet hier auch den Kanal "09 - Web". Dieser soll in XZuFi nicht
 * genutzt werden, sondern dafür Organisationseinheit.internetadresse.
 * @subpackage Structs
 */
class Erreichbarkeit extends AbstractStructBase
{
    /**
     * The kanal
     * Meta information extracted from the WSDL
     * - documentation: Der "kanal" gibt an, über welchen Erreichbarkeitskanal eine Kommunikation aufgenommen werden kann. Die referenzierte Codeliste "Erreichbarkeit" aus dem XRepository bietet hier auch den Kanal "09 - Web". Dieser soll in XZuFi hier
     * nicht genutzt werden, sondern dafür Organisationseinheit.internetadresse.
     * @var \StructType\Code_Erreichbarkeitskanal
     */
    public $kanal;
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - documentation: Die "kennung" beinhaltet die konkreten Angaben zur Erreichbarkeit über einen Kommunikationskanal, d.h. die Telefonnummer, Faxnummer, E-Mail-Adresse oder dergleichen. Die Kennung soll strukturiert erfasst werden.
     * @var string
     */
    public $kennung;
    /**
     * The kennungzusatz
     * Meta information extracted from the WSDL
     * - documentation: Optionaler Zusatz zur Kennung. Hier sollen keine Bemerkungen zur Erreichbarkeit o.ä. eingetragen werden. Es handelt sich um einen optionalen Zusatz der eigentlichen Kennung.
     * - minOccurs: 0
     * @var string
     */
    public $kennungzusatz;
    /**
     * The zusatz
     * Meta information extracted from the WSDL
     * - documentation: Dieser Zusatz diet zu Bemerkungen zur Kommunikation, z.B. Angaben über Kosten für Telefonnummern oder zur Erreichbarkeit.
     * - minOccurs: 0
     * @var string
     */
    public $zusatz;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Erreichbarkeit
     * @uses Erreichbarkeit::setKanal()
     * @uses Erreichbarkeit::setKennung()
     * @uses Erreichbarkeit::setKennungzusatz()
     * @uses Erreichbarkeit::setZusatz()
     * @uses Erreichbarkeit::setGueltigkeit()
     * @param \StructType\Code_Erreichbarkeitskanal $kanal
     * @param string $kennung
     * @param string $kennungzusatz
     * @param string $zusatz
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Code_Erreichbarkeitskanal $kanal = null, $kennung = null, $kennungzusatz = null, $zusatz = null, array $gueltigkeit = array())
    {
        $this
            ->setKanal($kanal)
            ->setKennung($kennung)
            ->setKennungzusatz($kennungzusatz)
            ->setZusatz($zusatz)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get kanal value
     * @return \StructType\Code_Erreichbarkeitskanal|null
     */
    public function getKanal()
    {
        return $this->kanal;
    }
    /**
     * Set kanal value
     * @param \StructType\Code_Erreichbarkeitskanal $kanal
     * @return \StructType\Erreichbarkeit
     */
    public function setKanal(\StructType\Code_Erreichbarkeitskanal $kanal = null)
    {
        $this->kanal = $kanal;
        return $this;
    }
    /**
     * Get kennung value
     * @return string|null
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \StructType\Erreichbarkeit
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
    /**
     * Get kennungzusatz value
     * @return string|null
     */
    public function getKennungzusatz()
    {
        return $this->kennungzusatz;
    }
    /**
     * Set kennungzusatz value
     * @param string $kennungzusatz
     * @return \StructType\Erreichbarkeit
     */
    public function setKennungzusatz($kennungzusatz = null)
    {
        // validation for constraint: string
        if (!is_null($kennungzusatz) && !is_string($kennungzusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennungzusatz, true), gettype($kennungzusatz)), __LINE__);
        }
        $this->kennungzusatz = $kennungzusatz;
        return $this;
    }
    /**
     * Get zusatz value
     * @return string|null
     */
    public function getZusatz()
    {
        return $this->zusatz;
    }
    /**
     * Set zusatz value
     * @param string $zusatz
     * @return \StructType\Erreichbarkeit
     */
    public function setZusatz($zusatz = null)
    {
        // validation for constraint: string
        if (!is_null($zusatz) && !is_string($zusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zusatz, true), gettype($zusatz)), __LINE__);
        }
        $this->zusatz = $zusatz;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $erreichbarkeitGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$erreichbarkeitGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($erreichbarkeitGueltigkeitItem) ? get_class($erreichbarkeitGueltigkeitItem) : sprintf('%s(%s)', gettype($erreichbarkeitGueltigkeitItem), var_export($erreichbarkeitGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Erreichbarkeit
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Erreichbarkeit
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
