<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EllipsoidType StructType
 * @subpackage Structs
 */
class EllipsoidType extends AbstractStructBase
{
    /**
     * The semiMajorAxis
     * @var \StructType\MeasureType
     */
    public $semiMajorAxis;
    /**
     * The secondDefiningParameter
     * @var \StructType\SecondDefiningParameter
     */
    public $secondDefiningParameter;
    /**
     * Constructor method for EllipsoidType
     * @uses EllipsoidType::setSemiMajorAxis()
     * @uses EllipsoidType::setSecondDefiningParameter()
     * @param \StructType\MeasureType $semiMajorAxis
     * @param \StructType\SecondDefiningParameter $secondDefiningParameter
     */
    public function __construct(\StructType\MeasureType $semiMajorAxis = null, \StructType\SecondDefiningParameter $secondDefiningParameter = null)
    {
        $this
            ->setSemiMajorAxis($semiMajorAxis)
            ->setSecondDefiningParameter($secondDefiningParameter);
    }
    /**
     * Get semiMajorAxis value
     * @return \StructType\MeasureType|null
     */
    public function getSemiMajorAxis()
    {
        return $this->semiMajorAxis;
    }
    /**
     * Set semiMajorAxis value
     * @param \StructType\MeasureType $semiMajorAxis
     * @return \StructType\EllipsoidType
     */
    public function setSemiMajorAxis(\StructType\MeasureType $semiMajorAxis = null)
    {
        $this->semiMajorAxis = $semiMajorAxis;
        return $this;
    }
    /**
     * Get secondDefiningParameter value
     * @return \StructType\SecondDefiningParameter|null
     */
    public function getSecondDefiningParameter()
    {
        return $this->secondDefiningParameter;
    }
    /**
     * Set secondDefiningParameter value
     * @param \StructType\SecondDefiningParameter $secondDefiningParameter
     * @return \StructType\EllipsoidType
     */
    public function setSecondDefiningParameter(\StructType\SecondDefiningParameter $secondDefiningParameter = null)
    {
        $this->secondDefiningParameter = $secondDefiningParameter;
        return $this;
    }
}
