<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EX_VerticalExtent_Type StructType
 * @subpackage Structs
 */
class EX_VerticalExtent_Type extends AbstractStructBase
{
    /**
     * The minimumValue
     * @var \StructType\Real_PropertyType
     */
    public $minimumValue;
    /**
     * The maximumValue
     * @var \StructType\Real_PropertyType
     */
    public $maximumValue;
    /**
     * The verticalCRS
     * @var \StructType\SC_CRS_PropertyType
     */
    public $verticalCRS;
    /**
     * Constructor method for EX_VerticalExtent_Type
     * @uses EX_VerticalExtent_Type::setMinimumValue()
     * @uses EX_VerticalExtent_Type::setMaximumValue()
     * @uses EX_VerticalExtent_Type::setVerticalCRS()
     * @param \StructType\Real_PropertyType $minimumValue
     * @param \StructType\Real_PropertyType $maximumValue
     * @param \StructType\SC_CRS_PropertyType $verticalCRS
     */
    public function __construct(\StructType\Real_PropertyType $minimumValue = null, \StructType\Real_PropertyType $maximumValue = null, \StructType\SC_CRS_PropertyType $verticalCRS = null)
    {
        $this
            ->setMinimumValue($minimumValue)
            ->setMaximumValue($maximumValue)
            ->setVerticalCRS($verticalCRS);
    }
    /**
     * Get minimumValue value
     * @return \StructType\Real_PropertyType|null
     */
    public function getMinimumValue()
    {
        return $this->minimumValue;
    }
    /**
     * Set minimumValue value
     * @param \StructType\Real_PropertyType $minimumValue
     * @return \StructType\EX_VerticalExtent_Type
     */
    public function setMinimumValue(\StructType\Real_PropertyType $minimumValue = null)
    {
        $this->minimumValue = $minimumValue;
        return $this;
    }
    /**
     * Get maximumValue value
     * @return \StructType\Real_PropertyType|null
     */
    public function getMaximumValue()
    {
        return $this->maximumValue;
    }
    /**
     * Set maximumValue value
     * @param \StructType\Real_PropertyType $maximumValue
     * @return \StructType\EX_VerticalExtent_Type
     */
    public function setMaximumValue(\StructType\Real_PropertyType $maximumValue = null)
    {
        $this->maximumValue = $maximumValue;
        return $this;
    }
    /**
     * Get verticalCRS value
     * @return \StructType\SC_CRS_PropertyType|null
     */
    public function getVerticalCRS()
    {
        return $this->verticalCRS;
    }
    /**
     * Set verticalCRS value
     * @param \StructType\SC_CRS_PropertyType $verticalCRS
     * @return \StructType\EX_VerticalExtent_Type
     */
    public function setVerticalCRS(\StructType\SC_CRS_PropertyType $verticalCRS = null)
    {
        $this->verticalCRS = $verticalCRS;
        return $this;
    }
}
