<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dokument StructType
 * Meta information extracted from the WSDL
 * - documentation: Dokument spezifiziert ein für eine Leistung beizubringendes oder aus einer Leistung hervorgehendes Dokument. Ein Dokument bezeichnet einen physischen oder elektronischen Informationsträger.
 * @subpackage Structs
 */
class Dokument extends AbstractStructBase
{
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Zugeordneter Dokumenttyp.
     * @var \StructType\DokumentTyp_Erweiterbar
     */
    public $typ;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Dokuments.
     * - maxOccurs: unbounded
     * @var \StructType\String_Localized[]
     */
    public $bezeichnung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung des Dokuments.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The referenzFormularID
     * Meta information extracted from the WSDL
     * - documentation: Optionale Referenz auf zum Dokument zugehörige oder entsprechende Formulare. Insbesondere können hier die IDs von FIM Datenfelder verwendet werden. Dies ist in den Scheme-Attributen des Identifikators zu vermerken.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $referenzFormularID;
    /**
     * The angabeSignatur
     * Meta information extracted from the WSDL
     * - documentation: Angabe über Notwendigkeit einer Signatur
     * - minOccurs: 0
     * @var \StructType\Code_Signatur
     */
    public $angabeSignatur;
    /**
     * Constructor method for Dokument
     * @uses Dokument::setTyp()
     * @uses Dokument::setBezeichnung()
     * @uses Dokument::setBeschreibung()
     * @uses Dokument::setReferenzFormularID()
     * @uses Dokument::setAngabeSignatur()
     * @param \StructType\DokumentTyp_Erweiterbar $typ
     * @param \StructType\String_Localized[] $bezeichnung
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\Identifikator[] $referenzFormularID
     * @param \StructType\Code_Signatur $angabeSignatur
     */
    public function __construct(\StructType\DokumentTyp_Erweiterbar $typ = null, array $bezeichnung = array(), array $beschreibung = array(), array $referenzFormularID = array(), \StructType\Code_Signatur $angabeSignatur = null)
    {
        $this
            ->setTyp($typ)
            ->setBezeichnung($bezeichnung)
            ->setBeschreibung($beschreibung)
            ->setReferenzFormularID($referenzFormularID)
            ->setAngabeSignatur($angabeSignatur);
    }
    /**
     * Get typ value
     * @return \StructType\DokumentTyp_Erweiterbar|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\DokumentTyp_Erweiterbar $typ
     * @return \StructType\Dokument
     */
    public function setTyp(\StructType\DokumentTyp_Erweiterbar $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dokumentBezeichnungItem) {
            // validation for constraint: itemType
            if (!$dokumentBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($dokumentBezeichnungItem) ? get_class($dokumentBezeichnungItem) : sprintf('%s(%s)', gettype($dokumentBezeichnungItem), var_export($dokumentBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $bezeichnung
     * @return \StructType\Dokument
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Dokument
     */
    public function addToBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dokumentBeschreibungItem) {
            // validation for constraint: itemType
            if (!$dokumentBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($dokumentBeschreibungItem) ? get_class($dokumentBeschreibungItem) : sprintf('%s(%s)', gettype($dokumentBeschreibungItem), var_export($dokumentBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Dokument
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Dokument
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get referenzFormularID value
     * @return \StructType\Identifikator[]|null
     */
    public function getReferenzFormularID()
    {
        return $this->referenzFormularID;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenzFormularID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenzFormularID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenzFormularIDForArrayConstraintsFromSetReferenzFormularID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dokumentReferenzFormularIDItem) {
            // validation for constraint: itemType
            if (!$dokumentReferenzFormularIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($dokumentReferenzFormularIDItem) ? get_class($dokumentReferenzFormularIDItem) : sprintf('%s(%s)', gettype($dokumentReferenzFormularIDItem), var_export($dokumentReferenzFormularIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The referenzFormularID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set referenzFormularID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $referenzFormularID
     * @return \StructType\Dokument
     */
    public function setReferenzFormularID(array $referenzFormularID = array())
    {
        // validation for constraint: array
        if ('' !== ($referenzFormularIDArrayErrorMessage = self::validateReferenzFormularIDForArrayConstraintsFromSetReferenzFormularID($referenzFormularID))) {
            throw new \InvalidArgumentException($referenzFormularIDArrayErrorMessage, __LINE__);
        }
        $this->referenzFormularID = $referenzFormularID;
        return $this;
    }
    /**
     * Add item to referenzFormularID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Dokument
     */
    public function addToReferenzFormularID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The referenzFormularID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->referenzFormularID[] = $item;
        return $this;
    }
    /**
     * Get angabeSignatur value
     * @return \StructType\Code_Signatur|null
     */
    public function getAngabeSignatur()
    {
        return $this->angabeSignatur;
    }
    /**
     * Set angabeSignatur value
     * @param \StructType\Code_Signatur $angabeSignatur
     * @return \StructType\Dokument
     */
    public function setAngabeSignatur(\StructType\Code_Signatur $angabeSignatur = null)
    {
        $this->angabeSignatur = $angabeSignatur;
        return $this;
    }
}
