<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectionVectorType StructType
 * @subpackage Structs
 */
class DirectionVectorType extends AbstractStructBase
{
    /**
     * The vector
     * @var \StructType\VectorType
     */
    public $vector;
    /**
     * The horizontalAngle
     * @var \StructType\AngleType
     */
    public $horizontalAngle;
    /**
     * The verticalAngle
     * @var \StructType\AngleType
     */
    public $verticalAngle;
    /**
     * Constructor method for DirectionVectorType
     * @uses DirectionVectorType::setVector()
     * @uses DirectionVectorType::setHorizontalAngle()
     * @uses DirectionVectorType::setVerticalAngle()
     * @param \StructType\VectorType $vector
     * @param \StructType\AngleType $horizontalAngle
     * @param \StructType\AngleType $verticalAngle
     */
    public function __construct(\StructType\VectorType $vector = null, \StructType\AngleType $horizontalAngle = null, \StructType\AngleType $verticalAngle = null)
    {
        $this
            ->setVector($vector)
            ->setHorizontalAngle($horizontalAngle)
            ->setVerticalAngle($verticalAngle);
    }
    /**
     * Get vector value
     * @return \StructType\VectorType|null
     */
    public function getVector()
    {
        return $this->vector;
    }
    /**
     * Set vector value
     * @param \StructType\VectorType $vector
     * @return \StructType\DirectionVectorType
     */
    public function setVector(\StructType\VectorType $vector = null)
    {
        $this->vector = $vector;
        return $this;
    }
    /**
     * Get horizontalAngle value
     * @return \StructType\AngleType|null
     */
    public function getHorizontalAngle()
    {
        return $this->horizontalAngle;
    }
    /**
     * Set horizontalAngle value
     * @param \StructType\AngleType $horizontalAngle
     * @return \StructType\DirectionVectorType
     */
    public function setHorizontalAngle(\StructType\AngleType $horizontalAngle = null)
    {
        $this->horizontalAngle = $horizontalAngle;
        return $this;
    }
    /**
     * Get verticalAngle value
     * @return \StructType\AngleType|null
     */
    public function getVerticalAngle()
    {
        return $this->verticalAngle;
    }
    /**
     * Set verticalAngle value
     * @param \StructType\AngleType $verticalAngle
     * @return \StructType\DirectionVectorType
     */
    public function setVerticalAngle(\StructType\AngleType $verticalAngle = null)
    {
        $this->verticalAngle = $verticalAngle;
        return $this;
    }
}
