<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DirectionDescriptionType StructType
 * @subpackage Structs
 */
class DirectionDescriptionType extends AbstractStructBase
{
    /**
     * The compassPoint
     * @var string
     */
    public $compassPoint;
    /**
     * The keyword
     * @var \StructType\CodeType
     */
    public $keyword;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The reference
     * @var \StructType\ReferenceType
     */
    public $reference;
    /**
     * Constructor method for DirectionDescriptionType
     * @uses DirectionDescriptionType::setCompassPoint()
     * @uses DirectionDescriptionType::setKeyword()
     * @uses DirectionDescriptionType::setDescription()
     * @uses DirectionDescriptionType::setReference()
     * @param string $compassPoint
     * @param \StructType\CodeType $keyword
     * @param string $description
     * @param \StructType\ReferenceType $reference
     */
    public function __construct($compassPoint = null, \StructType\CodeType $keyword = null, $description = null, \StructType\ReferenceType $reference = null)
    {
        $this
            ->setCompassPoint($compassPoint)
            ->setKeyword($keyword)
            ->setDescription($description)
            ->setReference($reference);
    }
    /**
     * Get compassPoint value
     * @return string|null
     */
    public function getCompassPoint()
    {
        return $this->compassPoint;
    }
    /**
     * Set compassPoint value
     * @param string $compassPoint
     * @return \StructType\DirectionDescriptionType
     */
    public function setCompassPoint($compassPoint = null)
    {
        // validation for constraint: string
        if (!is_null($compassPoint) && !is_string($compassPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compassPoint, true), gettype($compassPoint)), __LINE__);
        }
        $this->compassPoint = $compassPoint;
        return $this;
    }
    /**
     * Get keyword value
     * @return \StructType\CodeType|null
     */
    public function getKeyword()
    {
        return $this->keyword;
    }
    /**
     * Set keyword value
     * @param \StructType\CodeType $keyword
     * @return \StructType\DirectionDescriptionType
     */
    public function setKeyword(\StructType\CodeType $keyword = null)
    {
        $this->keyword = $keyword;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DirectionDescriptionType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get reference value
     * @return \StructType\ReferenceType|null
     */
    public function getReference()
    {
        return $this->reference;
    }
    /**
     * Set reference value
     * @param \StructType\ReferenceType $reference
     * @return \StructType\DirectionDescriptionType
     */
    public function setReference(\StructType\ReferenceType $reference = null)
    {
        $this->reference = $reference;
        return $this;
    }
}
