<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DerivedCRSType StructType
 * @subpackage Structs
 */
class DerivedCRSType extends AbstractStructBase
{
    /**
     * The baseCRS
     * @var \StructType\SingleCRSPropertyType
     */
    public $baseCRS;
    /**
     * The derivedCRSType
     * @var \StructType\CodeWithAuthorityType
     */
    public $derivedCRSType;
    /**
     * The coordinateSystem
     * @var \StructType\CoordinateSystemPropertyType
     */
    public $coordinateSystem;
    /**
     * Constructor method for DerivedCRSType
     * @uses DerivedCRSType::setBaseCRS()
     * @uses DerivedCRSType::setDerivedCRSType()
     * @uses DerivedCRSType::setCoordinateSystem()
     * @param \StructType\SingleCRSPropertyType $baseCRS
     * @param \StructType\CodeWithAuthorityType $derivedCRSType
     * @param \StructType\CoordinateSystemPropertyType $coordinateSystem
     */
    public function __construct(\StructType\SingleCRSPropertyType $baseCRS = null, \StructType\CodeWithAuthorityType $derivedCRSType = null, \StructType\CoordinateSystemPropertyType $coordinateSystem = null)
    {
        $this
            ->setBaseCRS($baseCRS)
            ->setDerivedCRSType($derivedCRSType)
            ->setCoordinateSystem($coordinateSystem);
    }
    /**
     * Get baseCRS value
     * @return \StructType\SingleCRSPropertyType|null
     */
    public function getBaseCRS()
    {
        return $this->baseCRS;
    }
    /**
     * Set baseCRS value
     * @param \StructType\SingleCRSPropertyType $baseCRS
     * @return \StructType\DerivedCRSType
     */
    public function setBaseCRS(\StructType\SingleCRSPropertyType $baseCRS = null)
    {
        $this->baseCRS = $baseCRS;
        return $this;
    }
    /**
     * Get derivedCRSType value
     * @return \StructType\CodeWithAuthorityType|null
     */
    public function getDerivedCRSType()
    {
        return $this->derivedCRSType;
    }
    /**
     * Set derivedCRSType value
     * @param \StructType\CodeWithAuthorityType $derivedCRSType
     * @return \StructType\DerivedCRSType
     */
    public function setDerivedCRSType(\StructType\CodeWithAuthorityType $derivedCRSType = null)
    {
        $this->derivedCRSType = $derivedCRSType;
        return $this;
    }
    /**
     * Get coordinateSystem value
     * @return \StructType\CoordinateSystemPropertyType|null
     */
    public function getCoordinateSystem()
    {
        return $this->coordinateSystem;
    }
    /**
     * Set coordinateSystem value
     * @param \StructType\CoordinateSystemPropertyType $coordinateSystem
     * @return \StructType\DerivedCRSType
     */
    public function setCoordinateSystem(\StructType\CoordinateSystemPropertyType $coordinateSystem = null)
    {
        $this->coordinateSystem = $coordinateSystem;
        return $this;
    }
}
