<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CurveArrayPropertyType StructType
 * @subpackage Structs
 */
class CurveArrayPropertyType extends AbstractStructBase
{
    /**
     * The AbstractCurve
     * @var \StructType\AbstractCurveType
     */
    public $AbstractCurve;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for CurveArrayPropertyType
     * @uses CurveArrayPropertyType::setAbstractCurve()
     * @uses CurveArrayPropertyType::setOwns()
     * @param \StructType\AbstractCurveType $abstractCurve
     * @param bool $owns
     */
    public function __construct(\StructType\AbstractCurveType $abstractCurve = null, $owns = null)
    {
        $this
            ->setAbstractCurve($abstractCurve)
            ->setOwns($owns);
    }
    /**
     * Get AbstractCurve value
     * @return \StructType\AbstractCurveType|null
     */
    public function getAbstractCurve()
    {
        return $this->AbstractCurve;
    }
    /**
     * Set AbstractCurve value
     * @param \StructType\AbstractCurveType $abstractCurve
     * @return \StructType\CurveArrayPropertyType
     */
    public function setAbstractCurve(\StructType\AbstractCurveType $abstractCurve = null)
    {
        $this->AbstractCurve = $abstractCurve;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\CurveArrayPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
