<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConcatenatedOperationType StructType
 * @subpackage Structs
 */
class ConcatenatedOperationType extends AbstractStructBase
{
    /**
     * The coordOperation
     * @var \StructType\CoordinateOperationPropertyType
     */
    public $coordOperation;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for ConcatenatedOperationType
     * @uses ConcatenatedOperationType::setCoordOperation()
     * @uses ConcatenatedOperationType::setAggregationType()
     * @param \StructType\CoordinateOperationPropertyType $coordOperation
     * @param string $aggregationType
     */
    public function __construct(\StructType\CoordinateOperationPropertyType $coordOperation = null, $aggregationType = null)
    {
        $this
            ->setCoordOperation($coordOperation)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get coordOperation value
     * @return \StructType\CoordinateOperationPropertyType|null
     */
    public function getCoordOperation()
    {
        return $this->coordOperation;
    }
    /**
     * Set coordOperation value
     * @param \StructType\CoordinateOperationPropertyType $coordOperation
     * @return \StructType\ConcatenatedOperationType
     */
    public function setCoordOperation(\StructType\CoordinateOperationPropertyType $coordOperation = null)
    {
        $this->coordOperation = $coordOperation;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\ConcatenatedOperationType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
