<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CharacterString_PropertyType StructType
 * @subpackage Structs
 */
class CharacterString_PropertyType extends AbstractStructBase
{
    /**
     * The CharacterString
     * @var string
     */
    public $CharacterString;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for CharacterString_PropertyType
     * @uses CharacterString_PropertyType::setCharacterString()
     * @uses CharacterString_PropertyType::setNilReason()
     * @param string $characterString
     * @param string $nilReason
     */
    public function __construct($characterString = null, $nilReason = null)
    {
        $this
            ->setCharacterString($characterString)
            ->setNilReason($nilReason);
    }
    /**
     * Get CharacterString value
     * @return string|null
     */
    public function getCharacterString()
    {
        return $this->CharacterString;
    }
    /**
     * Set CharacterString value
     * @param string $characterString
     * @return \StructType\CharacterString_PropertyType
     */
    public function setCharacterString($characterString = null)
    {
        // validation for constraint: string
        if (!is_null($characterString) && !is_string($characterString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($characterString, true), gettype($characterString)), __LINE__);
        }
        $this->CharacterString = $characterString;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\CharacterString_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
