<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bis StructType
 * Meta information extracted from the WSDL
 * - documentation: Ende des Intervalls.
 * @subpackage Structs
 */
class Bis extends AbstractStructBase
{
    /**
     * The datum
     * Meta information extracted from the WSDL
     * - documentation: Vollständiges Datum (Tag, Monat, Jahr).
     * - choice: datum | monatTag | tag
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $datum;
    /**
     * The monatTag
     * Meta information extracted from the WSDL
     * - documentation: Monat und Tag,
     * - choice: datum | monatTag | tag
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $monatTag;
    /**
     * The tag
     * Meta information extracted from the WSDL
     * - documentation: Tag eines Monats.
     * - choice: datum | monatTag | tag
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var gDay
     */
    public $tag;
    /**
     * Constructor method for bis
     * @uses Bis::setDatum()
     * @uses Bis::setMonatTag()
     * @uses Bis::setTag()
     * @param string $datum
     * @param int $monatTag
     * @param gDay $tag
     */
    public function __construct($datum = null, $monatTag = null, gDay $tag = null)
    {
        $this
            ->setDatum($datum)
            ->setMonatTag($monatTag)
            ->setTag($tag);
    }
    /**
     * Get datum value
     * @return string|null
     */
    public function getDatum()
    {
        return isset($this->datum) ? $this->datum : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDatum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatum method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDatumForChoiceConstraintsFromSetDatum($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'monatTag',
            'tag',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property datum can\'t be set as the property %s is already set. Only one property must be set among these properties: datum, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set datum value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $datum
     * @return \StructType\Bis
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        // validation for constraint: choice(datum, monatTag, tag)
        if ('' !== ($datumChoiceErrorMessage = self::validateDatumForChoiceConstraintsFromSetDatum($datum))) {
            throw new \InvalidArgumentException($datumChoiceErrorMessage, __LINE__);
        }
        if (is_null($datum) || (is_array($datum) && empty($datum))) {
            unset($this->datum);
        } else {
            $this->datum = $datum;
        }
        return $this;
    }
    /**
     * Get monatTag value
     * @return int|null
     */
    public function getMonatTag()
    {
        return isset($this->monatTag) ? $this->monatTag : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMonatTag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMonatTag method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMonatTagForChoiceConstraintsFromSetMonatTag($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'datum',
            'tag',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property monatTag can\'t be set as the property %s is already set. Only one property must be set among these properties: monatTag, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set monatTag value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $monatTag
     * @return \StructType\Bis
     */
    public function setMonatTag($monatTag = null)
    {
        // validation for constraint: int
        if (!is_null($monatTag) && !(is_int($monatTag) || ctype_digit($monatTag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($monatTag, true), gettype($monatTag)), __LINE__);
        }
        // validation for constraint: choice(datum, monatTag, tag)
        if ('' !== ($monatTagChoiceErrorMessage = self::validateMonatTagForChoiceConstraintsFromSetMonatTag($monatTag))) {
            throw new \InvalidArgumentException($monatTagChoiceErrorMessage, __LINE__);
        }
        if (is_null($monatTag) || (is_array($monatTag) && empty($monatTag))) {
            unset($this->monatTag);
        } else {
            $this->monatTag = $monatTag;
        }
        return $this;
    }
    /**
     * Get tag value
     * @return gDay|null
     */
    public function getTag()
    {
        return isset($this->tag) ? $this->tag : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTag method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTagForChoiceConstraintsFromSetTag($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'datum',
            'monatTag',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property tag can\'t be set as the property %s is already set. Only one property must be set among these properties: tag, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set tag value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param gDay $tag
     * @return \StructType\Bis
     */
    public function setTag(gDay $tag = null)
    {
        // validation for constraint: choice(datum, monatTag, tag)
        if ('' !== ($tagChoiceErrorMessage = self::validateTagForChoiceConstraintsFromSetTag($tag))) {
            throw new \InvalidArgumentException($tagChoiceErrorMessage, __LINE__);
        }
        if (is_null($tag) || (is_array($tag) && empty($tag))) {
            unset($this->tag);
        } else {
            $this->tag = $tag;
        }
        return $this;
    }
}
