<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasisinformationObjekt StructType
 * Meta information extracted from the WSDL
 * - documentation: BasisinformationObjekt enthält Basisinformationen zu Anwendungsobjekten aus XZuFi. Der Datentyp ist insbesondere für Nachrichten interessant, wenn nicht alle Informationen zu einem Objekt übertragen werden sollen.
 * @subpackage Structs
 */
class BasisinformationObjekt extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID des Objekts.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The identifikationsbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Identifikationsstring des Objekts, z.B. zur Darstellung in Ergebnislisten. Meist die Bezeichnung bzw. der Name von Objekten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $identifikationsbezeichnung;
    /**
     * The versionsinformation
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Versionierung.
     * - minOccurs: 0
     * @var \StructType\Versionsinformation
     */
    public $versionsinformation;
    /**
     * The sprache
     * Meta information extracted from the WSDL
     * - documentation: Code der Sprache der verfügbaren Sprachversionen des Objekts. Abgebildet mit W3C-Datentyp language (https://www.w3.org/TR/xmlschema-2/#language). Zum Beispiel "en", "en-US", "de", "de-DE" oder "zh-cn".
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $sprache;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for BasisinformationObjekt
     * @uses BasisinformationObjekt::setId()
     * @uses BasisinformationObjekt::setIdentifikationsbezeichnung()
     * @uses BasisinformationObjekt::setVersionsinformation()
     * @uses BasisinformationObjekt::setSprache()
     * @uses BasisinformationObjekt::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\String_Localized[] $identifikationsbezeichnung
     * @param \StructType\Versionsinformation $versionsinformation
     * @param string[] $sprache
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $identifikationsbezeichnung = array(), \StructType\Versionsinformation $versionsinformation = null, array $sprache = array(), array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdentifikationsbezeichnung($identifikationsbezeichnung)
            ->setVersionsinformation($versionsinformation)
            ->setSprache($sprache)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\BasisinformationObjekt
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get identifikationsbezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getIdentifikationsbezeichnung()
    {
        return $this->identifikationsbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentifikationsbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentifikationsbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentifikationsbezeichnungForArrayConstraintsFromSetIdentifikationsbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basisinformationObjektIdentifikationsbezeichnungItem) {
            // validation for constraint: itemType
            if (!$basisinformationObjektIdentifikationsbezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($basisinformationObjektIdentifikationsbezeichnungItem) ? get_class($basisinformationObjektIdentifikationsbezeichnungItem) : sprintf('%s(%s)', gettype($basisinformationObjektIdentifikationsbezeichnungItem), var_export($basisinformationObjektIdentifikationsbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The identifikationsbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set identifikationsbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $identifikationsbezeichnung
     * @return \StructType\BasisinformationObjekt
     */
    public function setIdentifikationsbezeichnung(array $identifikationsbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($identifikationsbezeichnungArrayErrorMessage = self::validateIdentifikationsbezeichnungForArrayConstraintsFromSetIdentifikationsbezeichnung($identifikationsbezeichnung))) {
            throw new \InvalidArgumentException($identifikationsbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->identifikationsbezeichnung = $identifikationsbezeichnung;
        return $this;
    }
    /**
     * Add item to identifikationsbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\BasisinformationObjekt
     */
    public function addToIdentifikationsbezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The identifikationsbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->identifikationsbezeichnung[] = $item;
        return $this;
    }
    /**
     * Get versionsinformation value
     * @return \StructType\Versionsinformation|null
     */
    public function getVersionsinformation()
    {
        return $this->versionsinformation;
    }
    /**
     * Set versionsinformation value
     * @param \StructType\Versionsinformation $versionsinformation
     * @return \StructType\BasisinformationObjekt
     */
    public function setVersionsinformation(\StructType\Versionsinformation $versionsinformation = null)
    {
        $this->versionsinformation = $versionsinformation;
        return $this;
    }
    /**
     * Get sprache value
     * @return string[]|null
     */
    public function getSprache()
    {
        return $this->sprache;
    }
    /**
     * This method is responsible for validating the values passed to the setSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpracheForArrayConstraintsFromSetSprache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basisinformationObjektSpracheItem) {
            // validation for constraint: itemType
            if (!is_string($basisinformationObjektSpracheItem)) {
                $invalidValues[] = is_object($basisinformationObjektSpracheItem) ? get_class($basisinformationObjektSpracheItem) : sprintf('%s(%s)', gettype($basisinformationObjektSpracheItem), var_export($basisinformationObjektSpracheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprache property can only contain items of type language, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprache value
     * @throws \InvalidArgumentException
     * @param string[] $sprache
     * @return \StructType\BasisinformationObjekt
     */
    public function setSprache(array $sprache = array())
    {
        // validation for constraint: array
        if ('' !== ($spracheArrayErrorMessage = self::validateSpracheForArrayConstraintsFromSetSprache($sprache))) {
            throw new \InvalidArgumentException($spracheArrayErrorMessage, __LINE__);
        }
        $this->sprache = $sprache;
        return $this;
    }
    /**
     * Add item to sprache value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\BasisinformationObjekt
     */
    public function addToSprache($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The sprache property can only contain items of type language, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprache[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $basisinformationObjektGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$basisinformationObjektGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($basisinformationObjektGueltigkeitItem) ? get_class($basisinformationObjektGueltigkeitItem) : sprintf('%s(%s)', gettype($basisinformationObjektGueltigkeitItem), var_export($basisinformationObjektGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\BasisinformationObjekt
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\BasisinformationObjekt
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
