<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Bankverbindung StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Bankverbindung umfasst alle notwendigen Informationen, um eine Überweisung auf ein Bankkonto vorzunehmen.Der Datentyp orientiert sich an SEPA-Überweisungen.
 * @subpackage Structs
 */
class Bankverbindung extends AbstractStructBase
{
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung/Erläuterung zur Verwendung dieser Bankverbindung.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The empfaenger
     * Meta information extracted from the WSDL
     * - documentation: Der Empfänger / Kontoinhaber auf dem Überweisungsträger.
     * @var string
     */
    public $empfaenger;
    /**
     * The iban
     * Meta information extracted from the WSDL
     * - documentation: Die IBAN (Kontonummer) setzt sich folgendermaßen zusammen:2-stelliger Ländercode (bestehend aus Buchstaben)2-stellige Prüfziffer (bestehend aus Ziffern)max. 30-stellige Kontoidentifikation (bestehend aus Buchstaben und/oder
     * Ziffern)
     * @var string
     */
    public $iban;
    /**
     * The bic
     * Meta information extracted from the WSDL
     * - documentation: Der SWIFT-BIC (BIC ist die Abkürzung für Bank Identifier Code) wird umgangssprachlich auch BIC-Code oder SWIFT-Code genannt. Es handelt sich um einen international standardisierten Bankcode.
     * - minOccurs: 0
     * @var string
     */
    public $bic;
    /**
     * The bankinstitut
     * Meta information extracted from the WSDL
     * - documentation: Bankinstitut des Empfängers
     * - minOccurs: 0
     * @var string
     */
    public $bankinstitut;
    /**
     * The verwendungszweckHinweis
     * Meta information extracted from the WSDL
     * - documentation: Hinweise zur Angabe des Verwendungszwecks / Referenz der Überweisung bzw. Kassenzeichen
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $verwendungszweckHinweis;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Optionale primäre ID.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Bankverbindung
     * @uses Bankverbindung::setBeschreibung()
     * @uses Bankverbindung::setEmpfaenger()
     * @uses Bankverbindung::setIban()
     * @uses Bankverbindung::setBic()
     * @uses Bankverbindung::setBankinstitut()
     * @uses Bankverbindung::setVerwendungszweckHinweis()
     * @uses Bankverbindung::setId()
     * @uses Bankverbindung::setIdSekundaer()
     * @uses Bankverbindung::setGueltigkeit()
     * @param \StructType\String_Localized[] $beschreibung
     * @param string $empfaenger
     * @param string $iban
     * @param string $bic
     * @param string $bankinstitut
     * @param \StructType\String_Localized[] $verwendungszweckHinweis
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(array $beschreibung = array(), $empfaenger = null, $iban = null, $bic = null, $bankinstitut = null, array $verwendungszweckHinweis = array(), \StructType\Identifikator $id = null, array $idSekundaer = array(), array $gueltigkeit = array())
    {
        $this
            ->setBeschreibung($beschreibung)
            ->setEmpfaenger($empfaenger)
            ->setIban($iban)
            ->setBic($bic)
            ->setBankinstitut($bankinstitut)
            ->setVerwendungszweckHinweis($verwendungszweckHinweis)
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bankverbindungBeschreibungItem) {
            // validation for constraint: itemType
            if (!$bankverbindungBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($bankverbindungBeschreibungItem) ? get_class($bankverbindungBeschreibungItem) : sprintf('%s(%s)', gettype($bankverbindungBeschreibungItem), var_export($bankverbindungBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Bankverbindung
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Bankverbindung
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get empfaenger value
     * @return string|null
     */
    public function getEmpfaenger()
    {
        return $this->empfaenger;
    }
    /**
     * Set empfaenger value
     * @param string $empfaenger
     * @return \StructType\Bankverbindung
     */
    public function setEmpfaenger($empfaenger = null)
    {
        // validation for constraint: string
        if (!is_null($empfaenger) && !is_string($empfaenger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($empfaenger, true), gettype($empfaenger)), __LINE__);
        }
        $this->empfaenger = $empfaenger;
        return $this;
    }
    /**
     * Get iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->iban;
    }
    /**
     * Set iban value
     * @param string $iban
     * @return \StructType\Bankverbindung
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->iban = $iban;
        return $this;
    }
    /**
     * Get bic value
     * @return string|null
     */
    public function getBic()
    {
        return $this->bic;
    }
    /**
     * Set bic value
     * @param string $bic
     * @return \StructType\Bankverbindung
     */
    public function setBic($bic = null)
    {
        // validation for constraint: string
        if (!is_null($bic) && !is_string($bic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bic, true), gettype($bic)), __LINE__);
        }
        $this->bic = $bic;
        return $this;
    }
    /**
     * Get bankinstitut value
     * @return string|null
     */
    public function getBankinstitut()
    {
        return $this->bankinstitut;
    }
    /**
     * Set bankinstitut value
     * @param string $bankinstitut
     * @return \StructType\Bankverbindung
     */
    public function setBankinstitut($bankinstitut = null)
    {
        // validation for constraint: string
        if (!is_null($bankinstitut) && !is_string($bankinstitut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankinstitut, true), gettype($bankinstitut)), __LINE__);
        }
        $this->bankinstitut = $bankinstitut;
        return $this;
    }
    /**
     * Get verwendungszweckHinweis value
     * @return \StructType\String_Localized[]|null
     */
    public function getVerwendungszweckHinweis()
    {
        return $this->verwendungszweckHinweis;
    }
    /**
     * This method is responsible for validating the values passed to the setVerwendungszweckHinweis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerwendungszweckHinweis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVerwendungszweckHinweisForArrayConstraintsFromSetVerwendungszweckHinweis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bankverbindungVerwendungszweckHinweisItem) {
            // validation for constraint: itemType
            if (!$bankverbindungVerwendungszweckHinweisItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($bankverbindungVerwendungszweckHinweisItem) ? get_class($bankverbindungVerwendungszweckHinweisItem) : sprintf('%s(%s)', gettype($bankverbindungVerwendungszweckHinweisItem), var_export($bankverbindungVerwendungszweckHinweisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The verwendungszweckHinweis property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set verwendungszweckHinweis value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $verwendungszweckHinweis
     * @return \StructType\Bankverbindung
     */
    public function setVerwendungszweckHinweis(array $verwendungszweckHinweis = array())
    {
        // validation for constraint: array
        if ('' !== ($verwendungszweckHinweisArrayErrorMessage = self::validateVerwendungszweckHinweisForArrayConstraintsFromSetVerwendungszweckHinweis($verwendungszweckHinweis))) {
            throw new \InvalidArgumentException($verwendungszweckHinweisArrayErrorMessage, __LINE__);
        }
        $this->verwendungszweckHinweis = $verwendungszweckHinweis;
        return $this;
    }
    /**
     * Add item to verwendungszweckHinweis value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Bankverbindung
     */
    public function addToVerwendungszweckHinweis(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The verwendungszweckHinweis property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->verwendungszweckHinweis[] = $item;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Bankverbindung
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bankverbindungIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$bankverbindungIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($bankverbindungIdSekundaerItem) ? get_class($bankverbindungIdSekundaerItem) : sprintf('%s(%s)', gettype($bankverbindungIdSekundaerItem), var_export($bankverbindungIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Bankverbindung
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Bankverbindung
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bankverbindungGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$bankverbindungGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($bankverbindungGueltigkeitItem) ? get_class($bankverbindungGueltigkeitItem) : sprintf('%s(%s)', gettype($bankverbindungGueltigkeitItem), var_export($bankverbindungGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Bankverbindung
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Bankverbindung
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
