<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BagType StructType
 * @subpackage Structs
 */
class BagType extends AbstractStructBase
{
    /**
     * The member
     * @var \StructType\AssociationRoleType
     */
    public $member;
    /**
     * The members
     * @var \StructType\ArrayAssociationType
     */
    public $members;
    /**
     * Constructor method for BagType
     * @uses BagType::setMember()
     * @uses BagType::setMembers()
     * @param \StructType\AssociationRoleType $member
     * @param \StructType\ArrayAssociationType $members
     */
    public function __construct(\StructType\AssociationRoleType $member = null, \StructType\ArrayAssociationType $members = null)
    {
        $this
            ->setMember($member)
            ->setMembers($members);
    }
    /**
     * Get member value
     * @return \StructType\AssociationRoleType|null
     */
    public function getMember()
    {
        return $this->member;
    }
    /**
     * Set member value
     * @param \StructType\AssociationRoleType $member
     * @return \StructType\BagType
     */
    public function setMember(\StructType\AssociationRoleType $member = null)
    {
        $this->member = $member;
        return $this;
    }
    /**
     * Get members value
     * @return \StructType\ArrayAssociationType|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param \StructType\ArrayAssociationType $members
     * @return \StructType\BagType
     */
    public function setMembers(\StructType\ArrayAssociationType $members = null)
    {
        $this->members = $members;
        return $this;
    }
}
