<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BSplineType StructType
 * @subpackage Structs
 */
class BSplineType extends AbstractStructBase
{
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The pointProperty
     * @var \StructType\PointPropertyType
     */
    public $pointProperty;
    /**
     * The pointRep
     * @var \StructType\PointPropertyType
     */
    public $pointRep;
    /**
     * The posList
     * @var \StructType\DirectPositionListType
     */
    public $posList;
    /**
     * The coordinates
     * @var \StructType\CoordinatesType
     */
    public $coordinates;
    /**
     * The degree
     * @var int
     */
    public $degree;
    /**
     * The knot
     * @var \StructType\KnotPropertyType
     */
    public $knot;
    /**
     * The interpolation
     * @var string
     */
    public $interpolation;
    /**
     * The isPolynomial
     * @var bool
     */
    public $isPolynomial;
    /**
     * The knotType
     * @var string
     */
    public $knotType;
    /**
     * Constructor method for BSplineType
     * @uses BSplineType::setPos()
     * @uses BSplineType::setPointProperty()
     * @uses BSplineType::setPointRep()
     * @uses BSplineType::setPosList()
     * @uses BSplineType::setCoordinates()
     * @uses BSplineType::setDegree()
     * @uses BSplineType::setKnot()
     * @uses BSplineType::setInterpolation()
     * @uses BSplineType::setIsPolynomial()
     * @uses BSplineType::setKnotType()
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\PointPropertyType $pointProperty
     * @param \StructType\PointPropertyType $pointRep
     * @param \StructType\DirectPositionListType $posList
     * @param \StructType\CoordinatesType $coordinates
     * @param int $degree
     * @param \StructType\KnotPropertyType $knot
     * @param string $interpolation
     * @param bool $isPolynomial
     * @param string $knotType
     */
    public function __construct(\StructType\DirectPositionType $pos = null, \StructType\PointPropertyType $pointProperty = null, \StructType\PointPropertyType $pointRep = null, \StructType\DirectPositionListType $posList = null, \StructType\CoordinatesType $coordinates = null, $degree = null, \StructType\KnotPropertyType $knot = null, $interpolation = null, $isPolynomial = null, $knotType = null)
    {
        $this
            ->setPos($pos)
            ->setPointProperty($pointProperty)
            ->setPointRep($pointRep)
            ->setPosList($posList)
            ->setCoordinates($coordinates)
            ->setDegree($degree)
            ->setKnot($knot)
            ->setInterpolation($interpolation)
            ->setIsPolynomial($isPolynomial)
            ->setKnotType($knotType);
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\BSplineType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get pointProperty value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointProperty()
    {
        return $this->pointProperty;
    }
    /**
     * Set pointProperty value
     * @param \StructType\PointPropertyType $pointProperty
     * @return \StructType\BSplineType
     */
    public function setPointProperty(\StructType\PointPropertyType $pointProperty = null)
    {
        $this->pointProperty = $pointProperty;
        return $this;
    }
    /**
     * Get pointRep value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointRep()
    {
        return $this->pointRep;
    }
    /**
     * Set pointRep value
     * @param \StructType\PointPropertyType $pointRep
     * @return \StructType\BSplineType
     */
    public function setPointRep(\StructType\PointPropertyType $pointRep = null)
    {
        $this->pointRep = $pointRep;
        return $this;
    }
    /**
     * Get posList value
     * @return \StructType\DirectPositionListType|null
     */
    public function getPosList()
    {
        return $this->posList;
    }
    /**
     * Set posList value
     * @param \StructType\DirectPositionListType $posList
     * @return \StructType\BSplineType
     */
    public function setPosList(\StructType\DirectPositionListType $posList = null)
    {
        $this->posList = $posList;
        return $this;
    }
    /**
     * Get coordinates value
     * @return \StructType\CoordinatesType|null
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }
    /**
     * Set coordinates value
     * @param \StructType\CoordinatesType $coordinates
     * @return \StructType\BSplineType
     */
    public function setCoordinates(\StructType\CoordinatesType $coordinates = null)
    {
        $this->coordinates = $coordinates;
        return $this;
    }
    /**
     * Get degree value
     * @return int|null
     */
    public function getDegree()
    {
        return $this->degree;
    }
    /**
     * Set degree value
     * @param int $degree
     * @return \StructType\BSplineType
     */
    public function setDegree($degree = null)
    {
        // validation for constraint: int
        if (!is_null($degree) && !(is_int($degree) || ctype_digit($degree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($degree, true), gettype($degree)), __LINE__);
        }
        $this->degree = $degree;
        return $this;
    }
    /**
     * Get knot value
     * @return \StructType\KnotPropertyType|null
     */
    public function getKnot()
    {
        return $this->knot;
    }
    /**
     * Set knot value
     * @param \StructType\KnotPropertyType $knot
     * @return \StructType\BSplineType
     */
    public function setKnot(\StructType\KnotPropertyType $knot = null)
    {
        $this->knot = $knot;
        return $this;
    }
    /**
     * Get interpolation value
     * @return string|null
     */
    public function getInterpolation()
    {
        return $this->interpolation;
    }
    /**
     * Set interpolation value
     * @param string $interpolation
     * @return \StructType\BSplineType
     */
    public function setInterpolation($interpolation = null)
    {
        // validation for constraint: string
        if (!is_null($interpolation) && !is_string($interpolation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interpolation, true), gettype($interpolation)), __LINE__);
        }
        $this->interpolation = $interpolation;
        return $this;
    }
    /**
     * Get isPolynomial value
     * @return bool|null
     */
    public function getIsPolynomial()
    {
        return $this->isPolynomial;
    }
    /**
     * Set isPolynomial value
     * @param bool $isPolynomial
     * @return \StructType\BSplineType
     */
    public function setIsPolynomial($isPolynomial = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPolynomial) && !is_bool($isPolynomial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPolynomial, true), gettype($isPolynomial)), __LINE__);
        }
        $this->isPolynomial = $isPolynomial;
        return $this;
    }
    /**
     * Get knotType value
     * @return string|null
     */
    public function getKnotType()
    {
        return $this->knotType;
    }
    /**
     * Set knotType value
     * @param string $knotType
     * @return \StructType\BSplineType
     */
    public function setKnotType($knotType = null)
    {
        // validation for constraint: string
        if (!is_null($knotType) && !is_string($knotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($knotType, true), gettype($knotType)), __LINE__);
        }
        $this->knotType = $knotType;
        return $this;
    }
}
