<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuswahlLeistungBasisinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Ergebnis einer Leistungsanfrage. Enthält entweder die Leistungen oder die Basisinformationsobjekte zu Leistungen.
 * @subpackage Structs
 */
class AuswahlLeistungBasisinformation extends AbstractStructBase
{
    /**
     * The leistung
     * Meta information extracted from the WSDL
     * - documentation: Menge von Leistungen.
     * - choice: leistung | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Leistung[]
     */
    public $leistung;
    /**
     * The basisinformation
     * Meta information extracted from the WSDL
     * - documentation: Menge von Basisinformationen zu Leistungen.
     * - choice: leistung | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BasisinformationObjekt[]
     */
    public $basisinformation;
    /**
     * Constructor method for AuswahlLeistungBasisinformation
     * @uses AuswahlLeistungBasisinformation::setLeistung()
     * @uses AuswahlLeistungBasisinformation::setBasisinformation()
     * @param \StructType\Leistung[] $leistung
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     */
    public function __construct(array $leistung = array(), array $basisinformation = array())
    {
        $this
            ->setLeistung($leistung)
            ->setBasisinformation($basisinformation);
    }
    /**
     * Get leistung value
     * @return \StructType\Leistung[]|null
     */
    public function getLeistung()
    {
        return isset($this->leistung) ? $this->leistung : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungForArrayConstraintsFromSetLeistung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlLeistungBasisinformationLeistungItem) {
            // validation for constraint: itemType
            if (!$auswahlLeistungBasisinformationLeistungItem instanceof \StructType\Leistung) {
                $invalidValues[] = is_object($auswahlLeistungBasisinformationLeistungItem) ? get_class($auswahlLeistungBasisinformationLeistungItem) : sprintf('%s(%s)', gettype($auswahlLeistungBasisinformationLeistungItem), var_export($auswahlLeistungBasisinformationLeistungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistung property can only contain items of type \StructType\Leistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistung method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLeistungForChoiceConstraintsFromSetLeistung($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property leistung can\'t be set as the property %s is already set. Only one property must be set among these properties: leistung, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set leistung value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Leistung[] $leistung
     * @return \StructType\AuswahlLeistungBasisinformation
     */
    public function setLeistung(array $leistung = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungArrayErrorMessage = self::validateLeistungForArrayConstraintsFromSetLeistung($leistung))) {
            throw new \InvalidArgumentException($leistungArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(leistung, basisinformation)
        if ('' !== ($leistungChoiceErrorMessage = self::validateLeistungForChoiceConstraintsFromSetLeistung($leistung))) {
            throw new \InvalidArgumentException($leistungChoiceErrorMessage, __LINE__);
        }
        if (is_null($leistung) || (is_array($leistung) && empty($leistung))) {
            unset($this->leistung);
        } else {
            $this->leistung = $leistung;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToLeistung method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToLeistung($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property leistung can\'t be set as the property %s is already set. Only one property must be set among these properties: leistung, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to leistung value
     * @throws \InvalidArgumentException
     * @param \StructType\Leistung $item
     * @return \StructType\AuswahlLeistungBasisinformation
     */
    public function addToLeistung(\StructType\Leistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Leistung) {
            throw new \InvalidArgumentException(sprintf('The leistung property can only contain items of type \StructType\Leistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(leistung, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToLeistung($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->leistung[] = $item;
        return $this;
    }
    /**
     * Get basisinformation value
     * @return \StructType\BasisinformationObjekt[]|null
     */
    public function getBasisinformation()
    {
        return isset($this->basisinformation) ? $this->basisinformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasisinformationForArrayConstraintsFromSetBasisinformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlLeistungBasisinformationBasisinformationItem) {
            // validation for constraint: itemType
            if (!$auswahlLeistungBasisinformationBasisinformationItem instanceof \StructType\BasisinformationObjekt) {
                $invalidValues[] = is_object($auswahlLeistungBasisinformationBasisinformationItem) ? get_class($auswahlLeistungBasisinformationBasisinformationItem) : sprintf('%s(%s)', gettype($auswahlLeistungBasisinformationBasisinformationItem), var_export($auswahlLeistungBasisinformationBasisinformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBasisinformationForChoiceConstraintsFromSetBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'leistung',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set basisinformation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     * @return \StructType\AuswahlLeistungBasisinformation
     */
    public function setBasisinformation(array $basisinformation = array())
    {
        // validation for constraint: array
        if ('' !== ($basisinformationArrayErrorMessage = self::validateBasisinformationForArrayConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(leistung, basisinformation)
        if ('' !== ($basisinformationChoiceErrorMessage = self::validateBasisinformationForChoiceConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationChoiceErrorMessage, __LINE__);
        }
        if (is_null($basisinformation) || (is_array($basisinformation) && empty($basisinformation))) {
            unset($this->basisinformation);
        } else {
            $this->basisinformation = $basisinformation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'leistung',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to basisinformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt $item
     * @return \StructType\AuswahlLeistungBasisinformation
     */
    public function addToBasisinformation(\StructType\BasisinformationObjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BasisinformationObjekt) {
            throw new \InvalidArgumentException(sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(leistung, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBasisinformation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->basisinformation[] = $item;
        return $this;
    }
}
