<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuswahlGebietBasisinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Ergebnis einer Gebietsanfrage. Enthält entweder die Gebiete oder die Basisinformationsobjekte zu Gebieten.
 * @subpackage Structs
 */
class AuswahlGebietBasisinformation extends AbstractStructBase
{
    /**
     * The gebiet
     * Meta information extracted from the WSDL
     * - documentation: Menge von Gebieten.
     * - choice: gebiet | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Gebiet[]
     */
    public $gebiet;
    /**
     * The basisinformation
     * Meta information extracted from the WSDL
     * - documentation: Menge von Basisinformationen zu Gebieten.
     * - choice: gebiet | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BasisinformationObjekt[]
     */
    public $basisinformation;
    /**
     * Constructor method for AuswahlGebietBasisinformation
     * @uses AuswahlGebietBasisinformation::setGebiet()
     * @uses AuswahlGebietBasisinformation::setBasisinformation()
     * @param \StructType\Gebiet[] $gebiet
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     */
    public function __construct(array $gebiet = array(), array $basisinformation = array())
    {
        $this
            ->setGebiet($gebiet)
            ->setBasisinformation($basisinformation);
    }
    /**
     * Get gebiet value
     * @return \StructType\Gebiet[]|null
     */
    public function getGebiet()
    {
        return isset($this->gebiet) ? $this->gebiet : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGebiet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGebiet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGebietForArrayConstraintsFromSetGebiet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlGebietBasisinformationGebietItem) {
            // validation for constraint: itemType
            if (!$auswahlGebietBasisinformationGebietItem instanceof \StructType\Gebiet) {
                $invalidValues[] = is_object($auswahlGebietBasisinformationGebietItem) ? get_class($auswahlGebietBasisinformationGebietItem) : sprintf('%s(%s)', gettype($auswahlGebietBasisinformationGebietItem), var_export($auswahlGebietBasisinformationGebietItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gebiet property can only contain items of type \StructType\Gebiet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGebiet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGebiet method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGebietForChoiceConstraintsFromSetGebiet($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property gebiet can\'t be set as the property %s is already set. Only one property must be set among these properties: gebiet, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set gebiet value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Gebiet[] $gebiet
     * @return \StructType\AuswahlGebietBasisinformation
     */
    public function setGebiet(array $gebiet = array())
    {
        // validation for constraint: array
        if ('' !== ($gebietArrayErrorMessage = self::validateGebietForArrayConstraintsFromSetGebiet($gebiet))) {
            throw new \InvalidArgumentException($gebietArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(gebiet, basisinformation)
        if ('' !== ($gebietChoiceErrorMessage = self::validateGebietForChoiceConstraintsFromSetGebiet($gebiet))) {
            throw new \InvalidArgumentException($gebietChoiceErrorMessage, __LINE__);
        }
        if (is_null($gebiet) || (is_array($gebiet) && empty($gebiet))) {
            unset($this->gebiet);
        } else {
            $this->gebiet = $gebiet;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToGebiet method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToGebiet method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToGebiet($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property gebiet can\'t be set as the property %s is already set. Only one property must be set among these properties: gebiet, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to gebiet value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebiet $item
     * @return \StructType\AuswahlGebietBasisinformation
     */
    public function addToGebiet(\StructType\Gebiet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Gebiet) {
            throw new \InvalidArgumentException(sprintf('The gebiet property can only contain items of type \StructType\Gebiet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(gebiet, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToGebiet($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->gebiet[] = $item;
        return $this;
    }
    /**
     * Get basisinformation value
     * @return \StructType\BasisinformationObjekt[]|null
     */
    public function getBasisinformation()
    {
        return isset($this->basisinformation) ? $this->basisinformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasisinformationForArrayConstraintsFromSetBasisinformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlGebietBasisinformationBasisinformationItem) {
            // validation for constraint: itemType
            if (!$auswahlGebietBasisinformationBasisinformationItem instanceof \StructType\BasisinformationObjekt) {
                $invalidValues[] = is_object($auswahlGebietBasisinformationBasisinformationItem) ? get_class($auswahlGebietBasisinformationBasisinformationItem) : sprintf('%s(%s)', gettype($auswahlGebietBasisinformationBasisinformationItem), var_export($auswahlGebietBasisinformationBasisinformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBasisinformationForChoiceConstraintsFromSetBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'gebiet',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set basisinformation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     * @return \StructType\AuswahlGebietBasisinformation
     */
    public function setBasisinformation(array $basisinformation = array())
    {
        // validation for constraint: array
        if ('' !== ($basisinformationArrayErrorMessage = self::validateBasisinformationForArrayConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(gebiet, basisinformation)
        if ('' !== ($basisinformationChoiceErrorMessage = self::validateBasisinformationForChoiceConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationChoiceErrorMessage, __LINE__);
        }
        if (is_null($basisinformation) || (is_array($basisinformation) && empty($basisinformation))) {
            unset($this->basisinformation);
        } else {
            $this->basisinformation = $basisinformation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'gebiet',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to basisinformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt $item
     * @return \StructType\AuswahlGebietBasisinformation
     */
    public function addToBasisinformation(\StructType\BasisinformationObjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BasisinformationObjekt) {
            throw new \InvalidArgumentException(sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(gebiet, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBasisinformation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->basisinformation[] = $item;
        return $this;
    }
}
