<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuswahlFormularBasisinformation StructType
 * Meta information extracted from the WSDL
 * - documentation: Ergebnis einer Formularanfrage. Enthält entweder die Formulare oder die Basisinformationsobjekte zu Formularen.
 * @subpackage Structs
 */
class AuswahlFormularBasisinformation extends AbstractStructBase
{
    /**
     * The formular
     * Meta information extracted from the WSDL
     * - documentation: Menge von Formularen.
     * - choice: formular | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Formular[]
     */
    public $formular;
    /**
     * The basisinformation
     * Meta information extracted from the WSDL
     * - documentation: Menge von Basisinformationen zur Formularen.
     * - choice: formular | basisinformation
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BasisinformationObjekt[]
     */
    public $basisinformation;
    /**
     * Constructor method for AuswahlFormularBasisinformation
     * @uses AuswahlFormularBasisinformation::setFormular()
     * @uses AuswahlFormularBasisinformation::setBasisinformation()
     * @param \StructType\Formular[] $formular
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     */
    public function __construct(array $formular = array(), array $basisinformation = array())
    {
        $this
            ->setFormular($formular)
            ->setBasisinformation($basisinformation);
    }
    /**
     * Get formular value
     * @return \StructType\Formular[]|null
     */
    public function getFormular()
    {
        return isset($this->formular) ? $this->formular : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFormular method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFormular method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormularForArrayConstraintsFromSetFormular(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlFormularBasisinformationFormularItem) {
            // validation for constraint: itemType
            if (!$auswahlFormularBasisinformationFormularItem instanceof \StructType\Formular) {
                $invalidValues[] = is_object($auswahlFormularBasisinformationFormularItem) ? get_class($auswahlFormularBasisinformationFormularItem) : sprintf('%s(%s)', gettype($auswahlFormularBasisinformationFormularItem), var_export($auswahlFormularBasisinformationFormularItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The formular property can only contain items of type \StructType\Formular, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setFormular method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFormular method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFormularForChoiceConstraintsFromSetFormular($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property formular can\'t be set as the property %s is already set. Only one property must be set among these properties: formular, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set formular value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\Formular[] $formular
     * @return \StructType\AuswahlFormularBasisinformation
     */
    public function setFormular(array $formular = array())
    {
        // validation for constraint: array
        if ('' !== ($formularArrayErrorMessage = self::validateFormularForArrayConstraintsFromSetFormular($formular))) {
            throw new \InvalidArgumentException($formularArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(formular, basisinformation)
        if ('' !== ($formularChoiceErrorMessage = self::validateFormularForChoiceConstraintsFromSetFormular($formular))) {
            throw new \InvalidArgumentException($formularChoiceErrorMessage, __LINE__);
        }
        if (is_null($formular) || (is_array($formular) && empty($formular))) {
            unset($this->formular);
        } else {
            $this->formular = $formular;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToFormular method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToFormular method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToFormular($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'basisinformation',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property formular can\'t be set as the property %s is already set. Only one property must be set among these properties: formular, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to formular value
     * @throws \InvalidArgumentException
     * @param \StructType\Formular $item
     * @return \StructType\AuswahlFormularBasisinformation
     */
    public function addToFormular(\StructType\Formular $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Formular) {
            throw new \InvalidArgumentException(sprintf('The formular property can only contain items of type \StructType\Formular, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(formular, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToFormular($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->formular[] = $item;
        return $this;
    }
    /**
     * Get basisinformation value
     * @return \StructType\BasisinformationObjekt[]|null
     */
    public function getBasisinformation()
    {
        return isset($this->basisinformation) ? $this->basisinformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBasisinformationForArrayConstraintsFromSetBasisinformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $auswahlFormularBasisinformationBasisinformationItem) {
            // validation for constraint: itemType
            if (!$auswahlFormularBasisinformationBasisinformationItem instanceof \StructType\BasisinformationObjekt) {
                $invalidValues[] = is_object($auswahlFormularBasisinformationBasisinformationItem) ? get_class($auswahlFormularBasisinformationBasisinformationItem) : sprintf('%s(%s)', gettype($auswahlFormularBasisinformationBasisinformationItem), var_export($auswahlFormularBasisinformationBasisinformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBasisinformationForChoiceConstraintsFromSetBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'formular',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set basisinformation value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt[] $basisinformation
     * @return \StructType\AuswahlFormularBasisinformation
     */
    public function setBasisinformation(array $basisinformation = array())
    {
        // validation for constraint: array
        if ('' !== ($basisinformationArrayErrorMessage = self::validateBasisinformationForArrayConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(formular, basisinformation)
        if ('' !== ($basisinformationChoiceErrorMessage = self::validateBasisinformationForChoiceConstraintsFromSetBasisinformation($basisinformation))) {
            throw new \InvalidArgumentException($basisinformationChoiceErrorMessage, __LINE__);
        }
        if (is_null($basisinformation) || (is_array($basisinformation) && empty($basisinformation))) {
            unset($this->basisinformation);
        } else {
            $this->basisinformation = $basisinformation;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBasisinformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBasisinformation method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBasisinformation($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'formular',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property basisinformation can\'t be set as the property %s is already set. Only one property must be set among these properties: basisinformation, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to basisinformation value
     * @throws \InvalidArgumentException
     * @param \StructType\BasisinformationObjekt $item
     * @return \StructType\AuswahlFormularBasisinformation
     */
    public function addToBasisinformation(\StructType\BasisinformationObjekt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BasisinformationObjekt) {
            throw new \InvalidArgumentException(sprintf('The basisinformation property can only contain items of type \StructType\BasisinformationObjekt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(formular, basisinformation)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBasisinformation($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->basisinformation[] = $item;
        return $this;
    }
}
