<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArcByBulgeType StructType
 * @subpackage Structs
 */
class ArcByBulgeType extends AbstractStructBase
{
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The pointProperty
     * @var \StructType\PointPropertyType
     */
    public $pointProperty;
    /**
     * The pointRep
     * @var \StructType\PointPropertyType
     */
    public $pointRep;
    /**
     * The posList
     * @var \StructType\DirectPositionListType
     */
    public $posList;
    /**
     * The coordinates
     * @var \StructType\CoordinatesType
     */
    public $coordinates;
    /**
     * The bulge
     * @var float
     */
    public $bulge;
    /**
     * The normal
     * @var \StructType\VectorType
     */
    public $normal;
    /**
     * The numArc
     * @var int
     */
    public $numArc;
    /**
     * Constructor method for ArcByBulgeType
     * @uses ArcByBulgeType::setPos()
     * @uses ArcByBulgeType::setPointProperty()
     * @uses ArcByBulgeType::setPointRep()
     * @uses ArcByBulgeType::setPosList()
     * @uses ArcByBulgeType::setCoordinates()
     * @uses ArcByBulgeType::setBulge()
     * @uses ArcByBulgeType::setNormal()
     * @uses ArcByBulgeType::setNumArc()
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\PointPropertyType $pointProperty
     * @param \StructType\PointPropertyType $pointRep
     * @param \StructType\DirectPositionListType $posList
     * @param \StructType\CoordinatesType $coordinates
     * @param float $bulge
     * @param \StructType\VectorType $normal
     * @param int $numArc
     */
    public function __construct(\StructType\DirectPositionType $pos = null, \StructType\PointPropertyType $pointProperty = null, \StructType\PointPropertyType $pointRep = null, \StructType\DirectPositionListType $posList = null, \StructType\CoordinatesType $coordinates = null, $bulge = null, \StructType\VectorType $normal = null, $numArc = null)
    {
        $this
            ->setPos($pos)
            ->setPointProperty($pointProperty)
            ->setPointRep($pointRep)
            ->setPosList($posList)
            ->setCoordinates($coordinates)
            ->setBulge($bulge)
            ->setNormal($normal)
            ->setNumArc($numArc);
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\ArcByBulgeType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get pointProperty value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointProperty()
    {
        return $this->pointProperty;
    }
    /**
     * Set pointProperty value
     * @param \StructType\PointPropertyType $pointProperty
     * @return \StructType\ArcByBulgeType
     */
    public function setPointProperty(\StructType\PointPropertyType $pointProperty = null)
    {
        $this->pointProperty = $pointProperty;
        return $this;
    }
    /**
     * Get pointRep value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointRep()
    {
        return $this->pointRep;
    }
    /**
     * Set pointRep value
     * @param \StructType\PointPropertyType $pointRep
     * @return \StructType\ArcByBulgeType
     */
    public function setPointRep(\StructType\PointPropertyType $pointRep = null)
    {
        $this->pointRep = $pointRep;
        return $this;
    }
    /**
     * Get posList value
     * @return \StructType\DirectPositionListType|null
     */
    public function getPosList()
    {
        return $this->posList;
    }
    /**
     * Set posList value
     * @param \StructType\DirectPositionListType $posList
     * @return \StructType\ArcByBulgeType
     */
    public function setPosList(\StructType\DirectPositionListType $posList = null)
    {
        $this->posList = $posList;
        return $this;
    }
    /**
     * Get coordinates value
     * @return \StructType\CoordinatesType|null
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }
    /**
     * Set coordinates value
     * @param \StructType\CoordinatesType $coordinates
     * @return \StructType\ArcByBulgeType
     */
    public function setCoordinates(\StructType\CoordinatesType $coordinates = null)
    {
        $this->coordinates = $coordinates;
        return $this;
    }
    /**
     * Get bulge value
     * @return float|null
     */
    public function getBulge()
    {
        return $this->bulge;
    }
    /**
     * Set bulge value
     * @param float $bulge
     * @return \StructType\ArcByBulgeType
     */
    public function setBulge($bulge = null)
    {
        // validation for constraint: float
        if (!is_null($bulge) && !(is_float($bulge) || is_numeric($bulge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bulge, true), gettype($bulge)), __LINE__);
        }
        $this->bulge = $bulge;
        return $this;
    }
    /**
     * Get normal value
     * @return \StructType\VectorType|null
     */
    public function getNormal()
    {
        return $this->normal;
    }
    /**
     * Set normal value
     * @param \StructType\VectorType $normal
     * @return \StructType\ArcByBulgeType
     */
    public function setNormal(\StructType\VectorType $normal = null)
    {
        $this->normal = $normal;
        return $this;
    }
    /**
     * Get numArc value
     * @return int|null
     */
    public function getNumArc()
    {
        return $this->numArc;
    }
    /**
     * Set numArc value
     * @param int $numArc
     * @return \StructType\ArcByBulgeType
     */
    public function setNumArc($numArc = null)
    {
        // validation for constraint: int
        if (!is_null($numArc) && !(is_int($numArc) || ctype_digit($numArc))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numArc, true), gettype($numArc)), __LINE__);
        }
        $this->numArc = $numArc;
        return $this;
    }
}
