<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortKontaktperson StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zur einer Kontaktpersonabfrage.
 * @subpackage Structs
 */
class AntwortKontaktperson extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageKontaktperson
     */
    public $anfrage;
    /**
     * The ergebnis
     * Meta information extracted from the WSDL
     * - documentation: Die Kontaktpersonen als Ergebnis. Je nach Wahl im Suchprofil als Kontaktperson oder Basisinformation.
     * - minOccurs: 0
     * @var \StructType\AuswahlKontaktpersonBasisinformation
     */
    public $ergebnis;
    /**
     * Constructor method for AntwortKontaktperson
     * @uses AntwortKontaktperson::setAnfrage()
     * @uses AntwortKontaktperson::setErgebnis()
     * @param \StructType\AnfrageKontaktperson $anfrage
     * @param \StructType\AuswahlKontaktpersonBasisinformation $ergebnis
     */
    public function __construct(\StructType\AnfrageKontaktperson $anfrage = null, \StructType\AuswahlKontaktpersonBasisinformation $ergebnis = null)
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnis($ergebnis);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageKontaktperson|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageKontaktperson $anfrage
     * @return \StructType\AntwortKontaktperson
     */
    public function setAnfrage(\StructType\AnfrageKontaktperson $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnis value
     * @return \StructType\AuswahlKontaktpersonBasisinformation|null
     */
    public function getErgebnis()
    {
        return $this->ergebnis;
    }
    /**
     * Set ergebnis value
     * @param \StructType\AuswahlKontaktpersonBasisinformation $ergebnis
     * @return \StructType\AntwortKontaktperson
     */
    public function setErgebnis(\StructType\AuswahlKontaktpersonBasisinformation $ergebnis = null)
    {
        $this->ergebnis = $ergebnis;
        return $this;
    }
}
