<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortHerausgeber StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Anfrage nach Herausgebern.
 * @subpackage Structs
 */
class AntwortHerausgeber extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageHerausgeber
     */
    public $anfrage;
    /**
     * The ergebnisHerausgeber
     * Meta information extracted from the WSDL
     * - documentation: Ergebnis der Anfrage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Herausgeber[]
     */
    public $ergebnisHerausgeber;
    /**
     * Constructor method for AntwortHerausgeber
     * @uses AntwortHerausgeber::setAnfrage()
     * @uses AntwortHerausgeber::setErgebnisHerausgeber()
     * @param \StructType\AnfrageHerausgeber $anfrage
     * @param \StructType\Herausgeber[] $ergebnisHerausgeber
     */
    public function __construct(\StructType\AnfrageHerausgeber $anfrage = null, array $ergebnisHerausgeber = array())
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnisHerausgeber($ergebnisHerausgeber);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageHerausgeber|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageHerausgeber $anfrage
     * @return \StructType\AntwortHerausgeber
     */
    public function setAnfrage(\StructType\AnfrageHerausgeber $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnisHerausgeber value
     * @return \StructType\Herausgeber[]|null
     */
    public function getErgebnisHerausgeber()
    {
        return $this->ergebnisHerausgeber;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisHerausgeber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisHerausgeber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisHerausgeberForArrayConstraintsFromSetErgebnisHerausgeber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortHerausgeberErgebnisHerausgeberItem) {
            // validation for constraint: itemType
            if (!$antwortHerausgeberErgebnisHerausgeberItem instanceof \StructType\Herausgeber) {
                $invalidValues[] = is_object($antwortHerausgeberErgebnisHerausgeberItem) ? get_class($antwortHerausgeberErgebnisHerausgeberItem) : sprintf('%s(%s)', gettype($antwortHerausgeberErgebnisHerausgeberItem), var_export($antwortHerausgeberErgebnisHerausgeberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisHerausgeber property can only contain items of type \StructType\Herausgeber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisHerausgeber value
     * @throws \InvalidArgumentException
     * @param \StructType\Herausgeber[] $ergebnisHerausgeber
     * @return \StructType\AntwortHerausgeber
     */
    public function setErgebnisHerausgeber(array $ergebnisHerausgeber = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisHerausgeberArrayErrorMessage = self::validateErgebnisHerausgeberForArrayConstraintsFromSetErgebnisHerausgeber($ergebnisHerausgeber))) {
            throw new \InvalidArgumentException($ergebnisHerausgeberArrayErrorMessage, __LINE__);
        }
        $this->ergebnisHerausgeber = $ergebnisHerausgeber;
        return $this;
    }
    /**
     * Add item to ergebnisHerausgeber value
     * @throws \InvalidArgumentException
     * @param \StructType\Herausgeber $item
     * @return \StructType\AntwortHerausgeber
     */
    public function addToErgebnisHerausgeber(\StructType\Herausgeber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Herausgeber) {
            throw new \InvalidArgumentException(sprintf('The ergebnisHerausgeber property can only contain items of type \StructType\Herausgeber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisHerausgeber[] = $item;
        return $this;
    }
}
