<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AntwortGebietsklasse StructType
 * Meta information extracted from the WSDL
 * - documentation: Antwort zu einer Gebietsklassenanfrage.
 * @subpackage Structs
 */
class AntwortGebietsklasse extends NachrichtAntwort
{
    /**
     * The anfrage
     * Meta information extracted from the WSDL
     * - documentation: Die gestellte Anfrage zur Referenz.
     * @var \StructType\AnfrageGebietsklasse
     */
    public $anfrage;
    /**
     * The ergebnisGebietsklasse
     * Meta information extracted from the WSDL
     * - documentation: Ergebnis der Anfrage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Gebietsklasse[]
     */
    public $ergebnisGebietsklasse;
    /**
     * Constructor method for AntwortGebietsklasse
     * @uses AntwortGebietsklasse::setAnfrage()
     * @uses AntwortGebietsklasse::setErgebnisGebietsklasse()
     * @param \StructType\AnfrageGebietsklasse $anfrage
     * @param \StructType\Gebietsklasse[] $ergebnisGebietsklasse
     */
    public function __construct(\StructType\AnfrageGebietsklasse $anfrage = null, array $ergebnisGebietsklasse = array())
    {
        $this
            ->setAnfrage($anfrage)
            ->setErgebnisGebietsklasse($ergebnisGebietsklasse);
    }
    /**
     * Get anfrage value
     * @return \StructType\AnfrageGebietsklasse|null
     */
    public function getAnfrage()
    {
        return $this->anfrage;
    }
    /**
     * Set anfrage value
     * @param \StructType\AnfrageGebietsklasse $anfrage
     * @return \StructType\AntwortGebietsklasse
     */
    public function setAnfrage(\StructType\AnfrageGebietsklasse $anfrage = null)
    {
        $this->anfrage = $anfrage;
        return $this;
    }
    /**
     * Get ergebnisGebietsklasse value
     * @return \StructType\Gebietsklasse[]|null
     */
    public function getErgebnisGebietsklasse()
    {
        return $this->ergebnisGebietsklasse;
    }
    /**
     * This method is responsible for validating the values passed to the setErgebnisGebietsklasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErgebnisGebietsklasse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErgebnisGebietsklasseForArrayConstraintsFromSetErgebnisGebietsklasse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $antwortGebietsklasseErgebnisGebietsklasseItem) {
            // validation for constraint: itemType
            if (!$antwortGebietsklasseErgebnisGebietsklasseItem instanceof \StructType\Gebietsklasse) {
                $invalidValues[] = is_object($antwortGebietsklasseErgebnisGebietsklasseItem) ? get_class($antwortGebietsklasseErgebnisGebietsklasseItem) : sprintf('%s(%s)', gettype($antwortGebietsklasseErgebnisGebietsklasseItem), var_export($antwortGebietsklasseErgebnisGebietsklasseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ergebnisGebietsklasse property can only contain items of type \StructType\Gebietsklasse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ergebnisGebietsklasse value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebietsklasse[] $ergebnisGebietsklasse
     * @return \StructType\AntwortGebietsklasse
     */
    public function setErgebnisGebietsklasse(array $ergebnisGebietsklasse = array())
    {
        // validation for constraint: array
        if ('' !== ($ergebnisGebietsklasseArrayErrorMessage = self::validateErgebnisGebietsklasseForArrayConstraintsFromSetErgebnisGebietsklasse($ergebnisGebietsklasse))) {
            throw new \InvalidArgumentException($ergebnisGebietsklasseArrayErrorMessage, __LINE__);
        }
        $this->ergebnisGebietsklasse = $ergebnisGebietsklasse;
        return $this;
    }
    /**
     * Add item to ergebnisGebietsklasse value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebietsklasse $item
     * @return \StructType\AntwortGebietsklasse
     */
    public function addToErgebnisGebietsklasse(\StructType\Gebietsklasse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Gebietsklasse) {
            throw new \InvalidArgumentException(sprintf('The ergebnisGebietsklasse property can only contain items of type \StructType\Gebietsklasse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ergebnisGebietsklasse[] = $item;
        return $this;
    }
}
