<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amount StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Abbildung von Währungsbeträgen. Enthält den Betrag sowie den Währungscode. Orientiert sich am UN/CEFACT-Datentyp Amount.
 * @subpackage Structs
 */
class Amount extends AbstractStructBase
{
    /**
     * The currencyCode
     * Meta information extracted from the WSDL
     * - documentation: Code aus UN/ECE Rec.9 Codeliste. Auch veröffentlicht als ISO 4217.
     * - use: required
     * @var string
     */
    public $currencyCode;
    /**
     * The _
     * @var float
     */
    public $_;
    /**
     * Constructor method for Amount
     * @uses Amount::setCurrencyCode()
     * @uses Amount::set_()
     * @param string $currencyCode
     * @param float $_
     */
    public function __construct($currencyCode = null, $_ = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->set_($_);
    }
    /**
     * Get currencyCode value
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \StructType\Amount
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get _ value
     * @return float|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param float $_
     * @return \StructType\Amount
     */
    public function set_($_ = null)
    {
        // validation for constraint: float
        if (!is_null($_) && !(is_float($_) || is_numeric($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
