<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractObject_Type StructType
 * @subpackage Structs
 */
class AbstractObject_Type extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The uuid
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for AbstractObject_Type
     * @uses AbstractObject_Type::setId()
     * @uses AbstractObject_Type::setUuid()
     * @param string $id
     * @param string $uuid
     */
    public function __construct($id = null, $uuid = null)
    {
        $this
            ->setId($id)
            ->setUuid($uuid);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AbstractObject_Type
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\AbstractObject_Type
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uuid, true), gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
}
