<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractMD_Identification_Type StructType
 * @subpackage Structs
 */
class AbstractMD_Identification_Type extends AbstractStructBase
{
    /**
     * The citation
     * @var \StructType\CI_Citation_PropertyType
     */
    public $citation;
    /**
     * The abstract
     * @var \StructType\CharacterString_PropertyType
     */
    public $abstract;
    /**
     * The purpose
     * @var \StructType\CharacterString_PropertyType
     */
    public $purpose;
    /**
     * The credit
     * @var \StructType\CharacterString_PropertyType
     */
    public $credit;
    /**
     * The status
     * @var \StructType\MD_ProgressCode_PropertyType
     */
    public $status;
    /**
     * The pointOfContact
     * @var \StructType\CI_ResponsibleParty_PropertyType
     */
    public $pointOfContact;
    /**
     * The resourceMaintenance
     * @var \StructType\MD_MaintenanceInformation_PropertyType
     */
    public $resourceMaintenance;
    /**
     * The graphicOverview
     * @var \StructType\MD_BrowseGraphic_PropertyType
     */
    public $graphicOverview;
    /**
     * The resourceFormat
     * @var \StructType\MD_Format_PropertyType
     */
    public $resourceFormat;
    /**
     * The descriptiveKeywords
     * @var \StructType\MD_Keywords_PropertyType
     */
    public $descriptiveKeywords;
    /**
     * The resourceSpecificUsage
     * @var \StructType\MD_Usage_PropertyType
     */
    public $resourceSpecificUsage;
    /**
     * The resourceConstraints
     * @var \StructType\MD_Constraints_PropertyType
     */
    public $resourceConstraints;
    /**
     * The aggregationInfo
     * @var \StructType\MD_AggregateInformation_PropertyType
     */
    public $aggregationInfo;
    /**
     * Constructor method for AbstractMD_Identification_Type
     * @uses AbstractMD_Identification_Type::setCitation()
     * @uses AbstractMD_Identification_Type::setAbstract()
     * @uses AbstractMD_Identification_Type::setPurpose()
     * @uses AbstractMD_Identification_Type::setCredit()
     * @uses AbstractMD_Identification_Type::setStatus()
     * @uses AbstractMD_Identification_Type::setPointOfContact()
     * @uses AbstractMD_Identification_Type::setResourceMaintenance()
     * @uses AbstractMD_Identification_Type::setGraphicOverview()
     * @uses AbstractMD_Identification_Type::setResourceFormat()
     * @uses AbstractMD_Identification_Type::setDescriptiveKeywords()
     * @uses AbstractMD_Identification_Type::setResourceSpecificUsage()
     * @uses AbstractMD_Identification_Type::setResourceConstraints()
     * @uses AbstractMD_Identification_Type::setAggregationInfo()
     * @param \StructType\CI_Citation_PropertyType $citation
     * @param \StructType\CharacterString_PropertyType $abstract
     * @param \StructType\CharacterString_PropertyType $purpose
     * @param \StructType\CharacterString_PropertyType $credit
     * @param \StructType\MD_ProgressCode_PropertyType $status
     * @param \StructType\CI_ResponsibleParty_PropertyType $pointOfContact
     * @param \StructType\MD_MaintenanceInformation_PropertyType $resourceMaintenance
     * @param \StructType\MD_BrowseGraphic_PropertyType $graphicOverview
     * @param \StructType\MD_Format_PropertyType $resourceFormat
     * @param \StructType\MD_Keywords_PropertyType $descriptiveKeywords
     * @param \StructType\MD_Usage_PropertyType $resourceSpecificUsage
     * @param \StructType\MD_Constraints_PropertyType $resourceConstraints
     * @param \StructType\MD_AggregateInformation_PropertyType $aggregationInfo
     */
    public function __construct(\StructType\CI_Citation_PropertyType $citation = null, \StructType\CharacterString_PropertyType $abstract = null, \StructType\CharacterString_PropertyType $purpose = null, \StructType\CharacterString_PropertyType $credit = null, \StructType\MD_ProgressCode_PropertyType $status = null, \StructType\CI_ResponsibleParty_PropertyType $pointOfContact = null, \StructType\MD_MaintenanceInformation_PropertyType $resourceMaintenance = null, \StructType\MD_BrowseGraphic_PropertyType $graphicOverview = null, \StructType\MD_Format_PropertyType $resourceFormat = null, \StructType\MD_Keywords_PropertyType $descriptiveKeywords = null, \StructType\MD_Usage_PropertyType $resourceSpecificUsage = null, \StructType\MD_Constraints_PropertyType $resourceConstraints = null, \StructType\MD_AggregateInformation_PropertyType $aggregationInfo = null)
    {
        $this
            ->setCitation($citation)
            ->setAbstract($abstract)
            ->setPurpose($purpose)
            ->setCredit($credit)
            ->setStatus($status)
            ->setPointOfContact($pointOfContact)
            ->setResourceMaintenance($resourceMaintenance)
            ->setGraphicOverview($graphicOverview)
            ->setResourceFormat($resourceFormat)
            ->setDescriptiveKeywords($descriptiveKeywords)
            ->setResourceSpecificUsage($resourceSpecificUsage)
            ->setResourceConstraints($resourceConstraints)
            ->setAggregationInfo($aggregationInfo);
    }
    /**
     * Get citation value
     * @return \StructType\CI_Citation_PropertyType|null
     */
    public function getCitation()
    {
        return $this->citation;
    }
    /**
     * Set citation value
     * @param \StructType\CI_Citation_PropertyType $citation
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setCitation(\StructType\CI_Citation_PropertyType $citation = null)
    {
        $this->citation = $citation;
        return $this;
    }
    /**
     * Get abstract value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getAbstract()
    {
        return $this->abstract;
    }
    /**
     * Set abstract value
     * @param \StructType\CharacterString_PropertyType $abstract
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setAbstract(\StructType\CharacterString_PropertyType $abstract = null)
    {
        $this->abstract = $abstract;
        return $this;
    }
    /**
     * Get purpose value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getPurpose()
    {
        return $this->purpose;
    }
    /**
     * Set purpose value
     * @param \StructType\CharacterString_PropertyType $purpose
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setPurpose(\StructType\CharacterString_PropertyType $purpose = null)
    {
        $this->purpose = $purpose;
        return $this;
    }
    /**
     * Get credit value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @param \StructType\CharacterString_PropertyType $credit
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setCredit(\StructType\CharacterString_PropertyType $credit = null)
    {
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\MD_ProgressCode_PropertyType|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\MD_ProgressCode_PropertyType $status
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setStatus(\StructType\MD_ProgressCode_PropertyType $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get pointOfContact value
     * @return \StructType\CI_ResponsibleParty_PropertyType|null
     */
    public function getPointOfContact()
    {
        return $this->pointOfContact;
    }
    /**
     * Set pointOfContact value
     * @param \StructType\CI_ResponsibleParty_PropertyType $pointOfContact
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setPointOfContact(\StructType\CI_ResponsibleParty_PropertyType $pointOfContact = null)
    {
        $this->pointOfContact = $pointOfContact;
        return $this;
    }
    /**
     * Get resourceMaintenance value
     * @return \StructType\MD_MaintenanceInformation_PropertyType|null
     */
    public function getResourceMaintenance()
    {
        return $this->resourceMaintenance;
    }
    /**
     * Set resourceMaintenance value
     * @param \StructType\MD_MaintenanceInformation_PropertyType $resourceMaintenance
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setResourceMaintenance(\StructType\MD_MaintenanceInformation_PropertyType $resourceMaintenance = null)
    {
        $this->resourceMaintenance = $resourceMaintenance;
        return $this;
    }
    /**
     * Get graphicOverview value
     * @return \StructType\MD_BrowseGraphic_PropertyType|null
     */
    public function getGraphicOverview()
    {
        return $this->graphicOverview;
    }
    /**
     * Set graphicOverview value
     * @param \StructType\MD_BrowseGraphic_PropertyType $graphicOverview
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setGraphicOverview(\StructType\MD_BrowseGraphic_PropertyType $graphicOverview = null)
    {
        $this->graphicOverview = $graphicOverview;
        return $this;
    }
    /**
     * Get resourceFormat value
     * @return \StructType\MD_Format_PropertyType|null
     */
    public function getResourceFormat()
    {
        return $this->resourceFormat;
    }
    /**
     * Set resourceFormat value
     * @param \StructType\MD_Format_PropertyType $resourceFormat
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setResourceFormat(\StructType\MD_Format_PropertyType $resourceFormat = null)
    {
        $this->resourceFormat = $resourceFormat;
        return $this;
    }
    /**
     * Get descriptiveKeywords value
     * @return \StructType\MD_Keywords_PropertyType|null
     */
    public function getDescriptiveKeywords()
    {
        return $this->descriptiveKeywords;
    }
    /**
     * Set descriptiveKeywords value
     * @param \StructType\MD_Keywords_PropertyType $descriptiveKeywords
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setDescriptiveKeywords(\StructType\MD_Keywords_PropertyType $descriptiveKeywords = null)
    {
        $this->descriptiveKeywords = $descriptiveKeywords;
        return $this;
    }
    /**
     * Get resourceSpecificUsage value
     * @return \StructType\MD_Usage_PropertyType|null
     */
    public function getResourceSpecificUsage()
    {
        return $this->resourceSpecificUsage;
    }
    /**
     * Set resourceSpecificUsage value
     * @param \StructType\MD_Usage_PropertyType $resourceSpecificUsage
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setResourceSpecificUsage(\StructType\MD_Usage_PropertyType $resourceSpecificUsage = null)
    {
        $this->resourceSpecificUsage = $resourceSpecificUsage;
        return $this;
    }
    /**
     * Get resourceConstraints value
     * @return \StructType\MD_Constraints_PropertyType|null
     */
    public function getResourceConstraints()
    {
        return $this->resourceConstraints;
    }
    /**
     * Set resourceConstraints value
     * @param \StructType\MD_Constraints_PropertyType $resourceConstraints
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setResourceConstraints(\StructType\MD_Constraints_PropertyType $resourceConstraints = null)
    {
        $this->resourceConstraints = $resourceConstraints;
        return $this;
    }
    /**
     * Get aggregationInfo value
     * @return \StructType\MD_AggregateInformation_PropertyType|null
     */
    public function getAggregationInfo()
    {
        return $this->aggregationInfo;
    }
    /**
     * Set aggregationInfo value
     * @param \StructType\MD_AggregateInformation_PropertyType $aggregationInfo
     * @return \StructType\AbstractMD_Identification_Type
     */
    public function setAggregationInfo(\StructType\MD_AggregateInformation_PropertyType $aggregationInfo = null)
    {
        $this->aggregationInfo = $aggregationInfo;
        return $this;
    }
}
