<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractGriddedSurfaceType StructType
 * @subpackage Structs
 */
class AbstractGriddedSurfaceType extends AbstractStructBase
{
    /**
     * The rows
     * @var \StructType\Rows
     */
    public $rows;
    /**
     * The columns
     * @var int
     */
    public $columns;
    /**
     * Constructor method for AbstractGriddedSurfaceType
     * @uses AbstractGriddedSurfaceType::setRows()
     * @uses AbstractGriddedSurfaceType::setColumns()
     * @param \StructType\Rows $rows
     * @param int $columns
     */
    public function __construct(\StructType\Rows $rows = null, $columns = null)
    {
        $this
            ->setRows($rows)
            ->setColumns($columns);
    }
    /**
     * Get rows value
     * @return \StructType\Rows|null
     */
    public function getRows()
    {
        return $this->rows;
    }
    /**
     * Set rows value
     * @param \StructType\Rows $rows
     * @return \StructType\AbstractGriddedSurfaceType
     */
    public function setRows(\StructType\Rows $rows = null)
    {
        $this->rows = $rows;
        return $this;
    }
    /**
     * Get columns value
     * @return int|null
     */
    public function getColumns()
    {
        return $this->columns;
    }
    /**
     * Set columns value
     * @param int $columns
     * @return \StructType\AbstractGriddedSurfaceType
     */
    public function setColumns($columns = null)
    {
        // validation for constraint: int
        if (!is_null($columns) && !(is_int($columns) || ctype_digit($columns))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($columns, true), gettype($columns)), __LINE__);
        }
        $this->columns = $columns;
        return $this;
    }
}
