<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractGMLType StructType
 * @subpackage Structs
 */
class AbstractGMLType extends AbstractStructBase
{
    /**
     * The metaDataProperty
     * @var \StructType\MetaDataPropertyType
     */
    public $metaDataProperty;
    /**
     * The description
     * @var \StructType\StringOrRefType
     */
    public $description;
    /**
     * The descriptionReference
     * @var \StructType\ReferenceType
     */
    public $descriptionReference;
    /**
     * The identifier
     * @var \StructType\CodeWithAuthorityType
     */
    public $identifier;
    /**
     * The name
     * @var \StructType\CodeType
     */
    public $name;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * Constructor method for AbstractGMLType
     * @uses AbstractGMLType::setMetaDataProperty()
     * @uses AbstractGMLType::setDescription()
     * @uses AbstractGMLType::setDescriptionReference()
     * @uses AbstractGMLType::setIdentifier()
     * @uses AbstractGMLType::setName()
     * @uses AbstractGMLType::setId()
     * @param \StructType\MetaDataPropertyType $metaDataProperty
     * @param \StructType\StringOrRefType $description
     * @param \StructType\ReferenceType $descriptionReference
     * @param \StructType\CodeWithAuthorityType $identifier
     * @param \StructType\CodeType $name
     * @param string $id
     */
    public function __construct(\StructType\MetaDataPropertyType $metaDataProperty = null, \StructType\StringOrRefType $description = null, \StructType\ReferenceType $descriptionReference = null, \StructType\CodeWithAuthorityType $identifier = null, \StructType\CodeType $name = null, $id = null)
    {
        $this
            ->setMetaDataProperty($metaDataProperty)
            ->setDescription($description)
            ->setDescriptionReference($descriptionReference)
            ->setIdentifier($identifier)
            ->setName($name)
            ->setId($id);
    }
    /**
     * Get metaDataProperty value
     * @return \StructType\MetaDataPropertyType|null
     */
    public function getMetaDataProperty()
    {
        return $this->metaDataProperty;
    }
    /**
     * Set metaDataProperty value
     * @param \StructType\MetaDataPropertyType $metaDataProperty
     * @return \StructType\AbstractGMLType
     */
    public function setMetaDataProperty(\StructType\MetaDataPropertyType $metaDataProperty = null)
    {
        $this->metaDataProperty = $metaDataProperty;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\StringOrRefType|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param \StructType\StringOrRefType $description
     * @return \StructType\AbstractGMLType
     */
    public function setDescription(\StructType\StringOrRefType $description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get descriptionReference value
     * @return \StructType\ReferenceType|null
     */
    public function getDescriptionReference()
    {
        return $this->descriptionReference;
    }
    /**
     * Set descriptionReference value
     * @param \StructType\ReferenceType $descriptionReference
     * @return \StructType\AbstractGMLType
     */
    public function setDescriptionReference(\StructType\ReferenceType $descriptionReference = null)
    {
        $this->descriptionReference = $descriptionReference;
        return $this;
    }
    /**
     * Get identifier value
     * @return \StructType\CodeWithAuthorityType|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\CodeWithAuthorityType $identifier
     * @return \StructType\AbstractGMLType
     */
    public function setIdentifier(\StructType\CodeWithAuthorityType $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\CodeType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\CodeType $name
     * @return \StructType\AbstractGMLType
     */
    public function setName(\StructType\CodeType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\AbstractGMLType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
}
