<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractFeatureCollectionType StructType
 * @subpackage Structs
 */
class AbstractFeatureCollectionType extends AbstractStructBase
{
    /**
     * The featureMember
     * @var \StructType\FeaturePropertyType
     */
    public $featureMember;
    /**
     * The featureMembers
     * @var \ArrayType\FeatureArrayPropertyType
     */
    public $featureMembers;
    /**
     * Constructor method for AbstractFeatureCollectionType
     * @uses AbstractFeatureCollectionType::setFeatureMember()
     * @uses AbstractFeatureCollectionType::setFeatureMembers()
     * @param \StructType\FeaturePropertyType $featureMember
     * @param \ArrayType\FeatureArrayPropertyType $featureMembers
     */
    public function __construct(\StructType\FeaturePropertyType $featureMember = null, \ArrayType\FeatureArrayPropertyType $featureMembers = null)
    {
        $this
            ->setFeatureMember($featureMember)
            ->setFeatureMembers($featureMembers);
    }
    /**
     * Get featureMember value
     * @return \StructType\FeaturePropertyType|null
     */
    public function getFeatureMember()
    {
        return $this->featureMember;
    }
    /**
     * Set featureMember value
     * @param \StructType\FeaturePropertyType $featureMember
     * @return \StructType\AbstractFeatureCollectionType
     */
    public function setFeatureMember(\StructType\FeaturePropertyType $featureMember = null)
    {
        $this->featureMember = $featureMember;
        return $this;
    }
    /**
     * Get featureMembers value
     * @return \ArrayType\FeatureArrayPropertyType|null
     */
    public function getFeatureMembers()
    {
        return $this->featureMembers;
    }
    /**
     * Set featureMembers value
     * @param \ArrayType\FeatureArrayPropertyType $featureMembers
     * @return \StructType\AbstractFeatureCollectionType
     */
    public function setFeatureMembers(\ArrayType\FeatureArrayPropertyType $featureMembers = null)
    {
        $this->featureMembers = $featureMembers;
        return $this;
    }
}
