<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractDatumType StructType
 * @subpackage Structs
 */
class AbstractDatumType extends AbstractStructBase
{
    /**
     * The domainOfValidity
     * @var \StructType\DomainOfValidity
     */
    public $domainOfValidity;
    /**
     * The scope
     * @var string
     */
    public $scope;
    /**
     * The anchorDefinition
     * @var \StructType\CodeType
     */
    public $anchorDefinition;
    /**
     * The realizationEpoch
     * @var string
     */
    public $realizationEpoch;
    /**
     * Constructor method for AbstractDatumType
     * @uses AbstractDatumType::setDomainOfValidity()
     * @uses AbstractDatumType::setScope()
     * @uses AbstractDatumType::setAnchorDefinition()
     * @uses AbstractDatumType::setRealizationEpoch()
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @param string $scope
     * @param \StructType\CodeType $anchorDefinition
     * @param string $realizationEpoch
     */
    public function __construct(\StructType\DomainOfValidity $domainOfValidity = null, $scope = null, \StructType\CodeType $anchorDefinition = null, $realizationEpoch = null)
    {
        $this
            ->setDomainOfValidity($domainOfValidity)
            ->setScope($scope)
            ->setAnchorDefinition($anchorDefinition)
            ->setRealizationEpoch($realizationEpoch);
    }
    /**
     * Get domainOfValidity value
     * @return \StructType\DomainOfValidity|null
     */
    public function getDomainOfValidity()
    {
        return $this->domainOfValidity;
    }
    /**
     * Set domainOfValidity value
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @return \StructType\AbstractDatumType
     */
    public function setDomainOfValidity(\StructType\DomainOfValidity $domainOfValidity = null)
    {
        $this->domainOfValidity = $domainOfValidity;
        return $this;
    }
    /**
     * Get scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * Set scope value
     * @param string $scope
     * @return \StructType\AbstractDatumType
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scope, true), gettype($scope)), __LINE__);
        }
        $this->scope = $scope;
        return $this;
    }
    /**
     * Get anchorDefinition value
     * @return \StructType\CodeType|null
     */
    public function getAnchorDefinition()
    {
        return $this->anchorDefinition;
    }
    /**
     * Set anchorDefinition value
     * @param \StructType\CodeType $anchorDefinition
     * @return \StructType\AbstractDatumType
     */
    public function setAnchorDefinition(\StructType\CodeType $anchorDefinition = null)
    {
        $this->anchorDefinition = $anchorDefinition;
        return $this;
    }
    /**
     * Get realizationEpoch value
     * @return string|null
     */
    public function getRealizationEpoch()
    {
        return $this->realizationEpoch;
    }
    /**
     * Set realizationEpoch value
     * @param string $realizationEpoch
     * @return \StructType\AbstractDatumType
     */
    public function setRealizationEpoch($realizationEpoch = null)
    {
        // validation for constraint: string
        if (!is_null($realizationEpoch) && !is_string($realizationEpoch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($realizationEpoch, true), gettype($realizationEpoch)), __LINE__);
        }
        $this->realizationEpoch = $realizationEpoch;
        return $this;
    }
}
