<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbstractDQ_Element_Type StructType
 * @subpackage Structs
 */
class AbstractDQ_Element_Type extends AbstractStructBase
{
    /**
     * The nameOfMeasure
     * @var \StructType\CharacterString_PropertyType
     */
    public $nameOfMeasure;
    /**
     * The measureIdentification
     * @var \StructType\MD_Identifier_PropertyType
     */
    public $measureIdentification;
    /**
     * The measureDescription
     * @var \StructType\CharacterString_PropertyType
     */
    public $measureDescription;
    /**
     * The evaluationMethodType
     * @var \StructType\DQ_EvaluationMethodTypeCode_PropertyType
     */
    public $evaluationMethodType;
    /**
     * The evaluationMethodDescription
     * @var \StructType\CharacterString_PropertyType
     */
    public $evaluationMethodDescription;
    /**
     * The evaluationProcedure
     * @var \StructType\CI_Citation_PropertyType
     */
    public $evaluationProcedure;
    /**
     * The dateTime
     * @var \StructType\DateTime_PropertyType
     */
    public $dateTime;
    /**
     * The result
     * @var \StructType\DQ_Result_PropertyType
     */
    public $result;
    /**
     * Constructor method for AbstractDQ_Element_Type
     * @uses AbstractDQ_Element_Type::setNameOfMeasure()
     * @uses AbstractDQ_Element_Type::setMeasureIdentification()
     * @uses AbstractDQ_Element_Type::setMeasureDescription()
     * @uses AbstractDQ_Element_Type::setEvaluationMethodType()
     * @uses AbstractDQ_Element_Type::setEvaluationMethodDescription()
     * @uses AbstractDQ_Element_Type::setEvaluationProcedure()
     * @uses AbstractDQ_Element_Type::setDateTime()
     * @uses AbstractDQ_Element_Type::setResult()
     * @param \StructType\CharacterString_PropertyType $nameOfMeasure
     * @param \StructType\MD_Identifier_PropertyType $measureIdentification
     * @param \StructType\CharacterString_PropertyType $measureDescription
     * @param \StructType\DQ_EvaluationMethodTypeCode_PropertyType $evaluationMethodType
     * @param \StructType\CharacterString_PropertyType $evaluationMethodDescription
     * @param \StructType\CI_Citation_PropertyType $evaluationProcedure
     * @param \StructType\DateTime_PropertyType $dateTime
     * @param \StructType\DQ_Result_PropertyType $result
     */
    public function __construct(\StructType\CharacterString_PropertyType $nameOfMeasure = null, \StructType\MD_Identifier_PropertyType $measureIdentification = null, \StructType\CharacterString_PropertyType $measureDescription = null, \StructType\DQ_EvaluationMethodTypeCode_PropertyType $evaluationMethodType = null, \StructType\CharacterString_PropertyType $evaluationMethodDescription = null, \StructType\CI_Citation_PropertyType $evaluationProcedure = null, \StructType\DateTime_PropertyType $dateTime = null, \StructType\DQ_Result_PropertyType $result = null)
    {
        $this
            ->setNameOfMeasure($nameOfMeasure)
            ->setMeasureIdentification($measureIdentification)
            ->setMeasureDescription($measureDescription)
            ->setEvaluationMethodType($evaluationMethodType)
            ->setEvaluationMethodDescription($evaluationMethodDescription)
            ->setEvaluationProcedure($evaluationProcedure)
            ->setDateTime($dateTime)
            ->setResult($result);
    }
    /**
     * Get nameOfMeasure value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getNameOfMeasure()
    {
        return $this->nameOfMeasure;
    }
    /**
     * Set nameOfMeasure value
     * @param \StructType\CharacterString_PropertyType $nameOfMeasure
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setNameOfMeasure(\StructType\CharacterString_PropertyType $nameOfMeasure = null)
    {
        $this->nameOfMeasure = $nameOfMeasure;
        return $this;
    }
    /**
     * Get measureIdentification value
     * @return \StructType\MD_Identifier_PropertyType|null
     */
    public function getMeasureIdentification()
    {
        return $this->measureIdentification;
    }
    /**
     * Set measureIdentification value
     * @param \StructType\MD_Identifier_PropertyType $measureIdentification
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setMeasureIdentification(\StructType\MD_Identifier_PropertyType $measureIdentification = null)
    {
        $this->measureIdentification = $measureIdentification;
        return $this;
    }
    /**
     * Get measureDescription value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getMeasureDescription()
    {
        return $this->measureDescription;
    }
    /**
     * Set measureDescription value
     * @param \StructType\CharacterString_PropertyType $measureDescription
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setMeasureDescription(\StructType\CharacterString_PropertyType $measureDescription = null)
    {
        $this->measureDescription = $measureDescription;
        return $this;
    }
    /**
     * Get evaluationMethodType value
     * @return \StructType\DQ_EvaluationMethodTypeCode_PropertyType|null
     */
    public function getEvaluationMethodType()
    {
        return $this->evaluationMethodType;
    }
    /**
     * Set evaluationMethodType value
     * @param \StructType\DQ_EvaluationMethodTypeCode_PropertyType $evaluationMethodType
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setEvaluationMethodType(\StructType\DQ_EvaluationMethodTypeCode_PropertyType $evaluationMethodType = null)
    {
        $this->evaluationMethodType = $evaluationMethodType;
        return $this;
    }
    /**
     * Get evaluationMethodDescription value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getEvaluationMethodDescription()
    {
        return $this->evaluationMethodDescription;
    }
    /**
     * Set evaluationMethodDescription value
     * @param \StructType\CharacterString_PropertyType $evaluationMethodDescription
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setEvaluationMethodDescription(\StructType\CharacterString_PropertyType $evaluationMethodDescription = null)
    {
        $this->evaluationMethodDescription = $evaluationMethodDescription;
        return $this;
    }
    /**
     * Get evaluationProcedure value
     * @return \StructType\CI_Citation_PropertyType|null
     */
    public function getEvaluationProcedure()
    {
        return $this->evaluationProcedure;
    }
    /**
     * Set evaluationProcedure value
     * @param \StructType\CI_Citation_PropertyType $evaluationProcedure
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setEvaluationProcedure(\StructType\CI_Citation_PropertyType $evaluationProcedure = null)
    {
        $this->evaluationProcedure = $evaluationProcedure;
        return $this;
    }
    /**
     * Get dateTime value
     * @return \StructType\DateTime_PropertyType|null
     */
    public function getDateTime()
    {
        return $this->dateTime;
    }
    /**
     * Set dateTime value
     * @param \StructType\DateTime_PropertyType $dateTime
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setDateTime(\StructType\DateTime_PropertyType $dateTime = null)
    {
        $this->dateTime = $dateTime;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\DQ_Result_PropertyType|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\DQ_Result_PropertyType $result
     * @return \StructType\AbstractDQ_Element_Type
     */
    public function setResult(\StructType\DQ_Result_PropertyType $result = null)
    {
        $this->result = $result;
        return $this;
    }
}
