<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zustaendigkeitskriterium StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Zuständigkeitskriterium schränkt eine Zuständigkeit weiter ein. Kriterien sind zum Beispiel Anfangsbuchstaben von Nachnamen oder Geburtsjahre.
 * @subpackage Structs
 */
class Zustaendigkeitskriterium extends AbstractStructBase
{
    /**
     * The codeKriterium
     * Meta information extracted from the WSDL
     * - documentation: Der Code des Zuständigkeitskriteriums.
     * @var \StructType\ZustaendigkeitskriteriumCode_Erweiterbar
     */
    public $codeKriterium;
    /**
     * The auspraegung
     * Meta information extracted from the WSDL
     * - documentation: Die konkrete Ausprägung des Kriterium.
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $auspraegung;
    /**
     * Constructor method for Zustaendigkeitskriterium
     * @uses Zustaendigkeitskriterium::setCodeKriterium()
     * @uses Zustaendigkeitskriterium::setAuspraegung()
     * @param \StructType\ZustaendigkeitskriteriumCode_Erweiterbar $codeKriterium
     * @param string[] $auspraegung
     */
    public function __construct(\StructType\ZustaendigkeitskriteriumCode_Erweiterbar $codeKriterium = null, array $auspraegung = array())
    {
        $this
            ->setCodeKriterium($codeKriterium)
            ->setAuspraegung($auspraegung);
    }
    /**
     * Get codeKriterium value
     * @return \StructType\ZustaendigkeitskriteriumCode_Erweiterbar|null
     */
    public function getCodeKriterium()
    {
        return $this->codeKriterium;
    }
    /**
     * Set codeKriterium value
     * @param \StructType\ZustaendigkeitskriteriumCode_Erweiterbar $codeKriterium
     * @return \StructType\Zustaendigkeitskriterium
     */
    public function setCodeKriterium(\StructType\ZustaendigkeitskriteriumCode_Erweiterbar $codeKriterium = null)
    {
        $this->codeKriterium = $codeKriterium;
        return $this;
    }
    /**
     * Get auspraegung value
     * @return string[]|null
     */
    public function getAuspraegung()
    {
        return $this->auspraegung;
    }
    /**
     * This method is responsible for validating the values passed to the setAuspraegung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAuspraegung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAuspraegungForArrayConstraintsFromSetAuspraegung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitskriteriumAuspraegungItem) {
            // validation for constraint: itemType
            if (!is_string($zustaendigkeitskriteriumAuspraegungItem)) {
                $invalidValues[] = is_object($zustaendigkeitskriteriumAuspraegungItem) ? get_class($zustaendigkeitskriteriumAuspraegungItem) : sprintf('%s(%s)', gettype($zustaendigkeitskriteriumAuspraegungItem), var_export($zustaendigkeitskriteriumAuspraegungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The auspraegung property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set auspraegung value
     * @throws \InvalidArgumentException
     * @param string[] $auspraegung
     * @return \StructType\Zustaendigkeitskriterium
     */
    public function setAuspraegung(array $auspraegung = array())
    {
        // validation for constraint: array
        if ('' !== ($auspraegungArrayErrorMessage = self::validateAuspraegungForArrayConstraintsFromSetAuspraegung($auspraegung))) {
            throw new \InvalidArgumentException($auspraegungArrayErrorMessage, __LINE__);
        }
        $this->auspraegung = $auspraegung;
        return $this;
    }
    /**
     * Add item to auspraegung value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Zustaendigkeitskriterium
     */
    public function addToAuspraegung($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The auspraegung property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->auspraegung[] = $item;
        return $this;
    }
}
