<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZustaendigkeitPerson StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieser Datentyp ist abgeleitet von 'Zustaendigkeit' und enthält Elemente, welche spezifisch für die Zuständigkeit von Personen sind.
 * @subpackage Structs
 */
class ZustaendigkeitPerson extends Zustaendigkeit
{
    /**
     * The kriterium
     * Meta information extracted from the WSDL
     * - documentation: Weitere Kriterien der Zuständigkeit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zustaendigkeitskriterium[]
     */
    public $kriterium;
    /**
     * Constructor method for ZustaendigkeitPerson
     * @uses ZustaendigkeitPerson::setKriterium()
     * @param \StructType\Zustaendigkeitskriterium[] $kriterium
     */
    public function __construct(array $kriterium = array())
    {
        $this
            ->setKriterium($kriterium);
    }
    /**
     * Get kriterium value
     * @return \StructType\Zustaendigkeitskriterium[]|null
     */
    public function getKriterium()
    {
        return $this->kriterium;
    }
    /**
     * This method is responsible for validating the values passed to the setKriterium method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKriterium method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKriteriumForArrayConstraintsFromSetKriterium(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitPersonKriteriumItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitPersonKriteriumItem instanceof \StructType\Zustaendigkeitskriterium) {
                $invalidValues[] = is_object($zustaendigkeitPersonKriteriumItem) ? get_class($zustaendigkeitPersonKriteriumItem) : sprintf('%s(%s)', gettype($zustaendigkeitPersonKriteriumItem), var_export($zustaendigkeitPersonKriteriumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kriterium property can only contain items of type \StructType\Zustaendigkeitskriterium, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kriterium value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeitskriterium[] $kriterium
     * @return \StructType\ZustaendigkeitPerson
     */
    public function setKriterium(array $kriterium = array())
    {
        // validation for constraint: array
        if ('' !== ($kriteriumArrayErrorMessage = self::validateKriteriumForArrayConstraintsFromSetKriterium($kriterium))) {
            throw new \InvalidArgumentException($kriteriumArrayErrorMessage, __LINE__);
        }
        $this->kriterium = $kriterium;
        return $this;
    }
    /**
     * Add item to kriterium value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeitskriterium $item
     * @return \StructType\ZustaendigkeitPerson
     */
    public function addToKriterium(\StructType\Zustaendigkeitskriterium $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zustaendigkeitskriterium) {
            throw new \InvalidArgumentException(sprintf('The kriterium property can only contain items of type \StructType\Zustaendigkeitskriterium, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kriterium[] = $item;
        return $this;
    }
}
