<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZustaendigkeitOrganisationseinheit StructType
 * Meta information extracted from the WSDL
 * - documentation: Dieser Datentyp ist abgeleitet von 'Zustaendigkeit' und enthält Elemente, welche spezifisch für die Zuständigkeit von Stellen sind.
 * @subpackage Structs
 */
class ZustaendigkeitOrganisationseinheit extends Zustaendigkeit
{
    /**
     * The rolle
     * Meta information extracted from the WSDL
     * - documentation: Präzisierung, ob die Zuständigkeit als zuständige Stelle und/oder Ansprechpunkt fungiert.
     * - minOccurs: 0
     * @var \StructType\Code_Zustaendigkeitsrolle
     */
    public $rolle;
    /**
     * The kriterium
     * Meta information extracted from the WSDL
     * - documentation: Weitere Kriterien der Zuständigkeit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zustaendigkeitskriterium[]
     */
    public $kriterium;
    /**
     * Constructor method for ZustaendigkeitOrganisationseinheit
     * @uses ZustaendigkeitOrganisationseinheit::setRolle()
     * @uses ZustaendigkeitOrganisationseinheit::setKriterium()
     * @param \StructType\Code_Zustaendigkeitsrolle $rolle
     * @param \StructType\Zustaendigkeitskriterium[] $kriterium
     */
    public function __construct(\StructType\Code_Zustaendigkeitsrolle $rolle = null, array $kriterium = array())
    {
        $this
            ->setRolle($rolle)
            ->setKriterium($kriterium);
    }
    /**
     * Get rolle value
     * @return \StructType\Code_Zustaendigkeitsrolle|null
     */
    public function getRolle()
    {
        return $this->rolle;
    }
    /**
     * Set rolle value
     * @param \StructType\Code_Zustaendigkeitsrolle $rolle
     * @return \StructType\ZustaendigkeitOrganisationseinheit
     */
    public function setRolle(\StructType\Code_Zustaendigkeitsrolle $rolle = null)
    {
        $this->rolle = $rolle;
        return $this;
    }
    /**
     * Get kriterium value
     * @return \StructType\Zustaendigkeitskriterium[]|null
     */
    public function getKriterium()
    {
        return $this->kriterium;
    }
    /**
     * This method is responsible for validating the values passed to the setKriterium method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKriterium method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKriteriumForArrayConstraintsFromSetKriterium(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $zustaendigkeitOrganisationseinheitKriteriumItem) {
            // validation for constraint: itemType
            if (!$zustaendigkeitOrganisationseinheitKriteriumItem instanceof \StructType\Zustaendigkeitskriterium) {
                $invalidValues[] = is_object($zustaendigkeitOrganisationseinheitKriteriumItem) ? get_class($zustaendigkeitOrganisationseinheitKriteriumItem) : sprintf('%s(%s)', gettype($zustaendigkeitOrganisationseinheitKriteriumItem), var_export($zustaendigkeitOrganisationseinheitKriteriumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kriterium property can only contain items of type \StructType\Zustaendigkeitskriterium, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kriterium value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeitskriterium[] $kriterium
     * @return \StructType\ZustaendigkeitOrganisationseinheit
     */
    public function setKriterium(array $kriterium = array())
    {
        // validation for constraint: array
        if ('' !== ($kriteriumArrayErrorMessage = self::validateKriteriumForArrayConstraintsFromSetKriterium($kriterium))) {
            throw new \InvalidArgumentException($kriteriumArrayErrorMessage, __LINE__);
        }
        $this->kriterium = $kriterium;
        return $this;
    }
    /**
     * Add item to kriterium value
     * @throws \InvalidArgumentException
     * @param \StructType\Zustaendigkeitskriterium $item
     * @return \StructType\ZustaendigkeitOrganisationseinheit
     */
    public function addToKriterium(\StructType\Zustaendigkeitskriterium $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zustaendigkeitskriterium) {
            throw new \InvalidArgumentException(sprintf('The kriterium property can only contain items of type \StructType\Zustaendigkeitskriterium, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kriterium[] = $item;
        return $this;
    }
}
