<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Wirtschaftszweig_Spezifizierbar StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Wirtschaftszweig bezeichnet in der Wirtschaft eine Gruppe von Unternehmen, die ähnliche Güter herstellen. Code der Wirtschaftszweige von Destatis oder ein eigener spezifischer Code des Wirtschaftszweiges oder der Branche.
 * @subpackage Structs
 */
class Wirtschaftszweig_Spezifizierbar extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: Code des Wirtschaftszweig von Destatis (WZ2008).
     * - choice: code | spezifischeID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Code_Wirtschaftszweig2008Destatis
     */
    public $code;
    /**
     * The spezifischeID
     * Meta information extracted from the WSDL
     * - documentation: Eigener Code/ID für Wirtschaftszweige. Anzustreben ist die Verwendung der offiziellen WZ von Destatis.
     * - choice: code | spezifischeID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Identifikator
     */
    public $spezifischeID;
    /**
     * Constructor method for Wirtschaftszweig_Spezifizierbar
     * @uses Wirtschaftszweig_Spezifizierbar::setCode()
     * @uses Wirtschaftszweig_Spezifizierbar::setSpezifischeID()
     * @param \StructType\Code_Wirtschaftszweig2008Destatis $code
     * @param \StructType\Identifikator $spezifischeID
     */
    public function __construct(\StructType\Code_Wirtschaftszweig2008Destatis $code = null, \StructType\Identifikator $spezifischeID = null)
    {
        $this
            ->setCode($code)
            ->setSpezifischeID($spezifischeID);
    }
    /**
     * Get code value
     * @return \StructType\Code_Wirtschaftszweig2008Destatis|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodeForChoiceConstraintsFromSetCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'spezifischeID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property code can\'t be set as the property %s is already set. Only one property must be set among these properties: code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Wirtschaftszweig2008Destatis $code
     * @return \StructType\Wirtschaftszweig_Spezifizierbar
     */
    public function setCode(\StructType\Code_Wirtschaftszweig2008Destatis $code = null)
    {
        // validation for constraint: choice(code, spezifischeID)
        if ('' !== ($codeChoiceErrorMessage = self::validateCodeForChoiceConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeChoiceErrorMessage, __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get spezifischeID value
     * @return \StructType\Identifikator|null
     */
    public function getSpezifischeID()
    {
        return isset($this->spezifischeID) ? $this->spezifischeID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSpezifischeID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpezifischeID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSpezifischeIDForChoiceConstraintsFromSetSpezifischeID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property spezifischeID can\'t be set as the property %s is already set. Only one property must be set among these properties: spezifischeID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set spezifischeID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $spezifischeID
     * @return \StructType\Wirtschaftszweig_Spezifizierbar
     */
    public function setSpezifischeID(\StructType\Identifikator $spezifischeID = null)
    {
        // validation for constraint: choice(code, spezifischeID)
        if ('' !== ($spezifischeIDChoiceErrorMessage = self::validateSpezifischeIDForChoiceConstraintsFromSetSpezifischeID($spezifischeID))) {
            throw new \InvalidArgumentException($spezifischeIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($spezifischeID) || (is_array($spezifischeID) && empty($spezifischeID))) {
            unset($this->spezifischeID);
        } else {
            $this->spezifischeID = $spezifischeID;
        }
        return $this;
    }
}
