<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueArrayType StructType
 * @subpackage Structs
 */
class ValueArrayType extends AbstractStructBase
{
    /**
     * The codeSpace
     * @var string
     */
    public $codeSpace;
    /**
     * The uom
     * @var string
     */
    public $uom;
    /**
     * Constructor method for ValueArrayType
     * @uses ValueArrayType::setCodeSpace()
     * @uses ValueArrayType::setUom()
     * @param string $codeSpace
     * @param string $uom
     */
    public function __construct($codeSpace = null, $uom = null)
    {
        $this
            ->setCodeSpace($codeSpace)
            ->setUom($uom);
    }
    /**
     * Get codeSpace value
     * @return string|null
     */
    public function getCodeSpace()
    {
        return $this->codeSpace;
    }
    /**
     * Set codeSpace value
     * @param string $codeSpace
     * @return \StructType\ValueArrayType
     */
    public function setCodeSpace($codeSpace = null)
    {
        // validation for constraint: string
        if (!is_null($codeSpace) && !is_string($codeSpace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeSpace, true), gettype($codeSpace)), __LINE__);
        }
        $this->codeSpace = $codeSpace;
        return $this;
    }
    /**
     * Get uom value
     * @return string|null
     */
    public function getUom()
    {
        return $this->uom;
    }
    /**
     * Set uom value
     * @param string $uom
     * @return \StructType\ValueArrayType
     */
    public function setUom($uom = null)
    {
        // validation for constraint: string
        if (!is_null($uom) && !is_string($uom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uom, true), gettype($uom)), __LINE__);
        }
        $this->uom = $uom;
        return $this;
    }
}
