<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnlimitedInteger_PropertyType StructType
 * @subpackage Structs
 */
class UnlimitedInteger_PropertyType extends AbstractStructBase
{
    /**
     * The UnlimitedInteger
     * @var \StructType\UnlimitedInteger_Type
     */
    public $UnlimitedInteger;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for UnlimitedInteger_PropertyType
     * @uses UnlimitedInteger_PropertyType::setUnlimitedInteger()
     * @uses UnlimitedInteger_PropertyType::setNilReason()
     * @param \StructType\UnlimitedInteger_Type $unlimitedInteger
     * @param string $nilReason
     */
    public function __construct(\StructType\UnlimitedInteger_Type $unlimitedInteger = null, $nilReason = null)
    {
        $this
            ->setUnlimitedInteger($unlimitedInteger)
            ->setNilReason($nilReason);
    }
    /**
     * Get UnlimitedInteger value
     * @return \StructType\UnlimitedInteger_Type|null
     */
    public function getUnlimitedInteger()
    {
        return $this->UnlimitedInteger;
    }
    /**
     * Set UnlimitedInteger value
     * @param \StructType\UnlimitedInteger_Type $unlimitedInteger
     * @return \StructType\UnlimitedInteger_PropertyType
     */
    public function setUnlimitedInteger(\StructType\UnlimitedInteger_Type $unlimitedInteger = null)
    {
        $this->UnlimitedInteger = $unlimitedInteger;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\UnlimitedInteger_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
