<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoSurfaceType StructType
 * @subpackage Structs
 */
class TopoSurfaceType extends AbstractStructBase
{
    /**
     * The directedFace
     * @var \StructType\DirectedFacePropertyType
     */
    public $directedFace;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for TopoSurfaceType
     * @uses TopoSurfaceType::setDirectedFace()
     * @uses TopoSurfaceType::setAggregationType()
     * @param \StructType\DirectedFacePropertyType $directedFace
     * @param string $aggregationType
     */
    public function __construct(\StructType\DirectedFacePropertyType $directedFace = null, $aggregationType = null)
    {
        $this
            ->setDirectedFace($directedFace)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get directedFace value
     * @return \StructType\DirectedFacePropertyType|null
     */
    public function getDirectedFace()
    {
        return $this->directedFace;
    }
    /**
     * Set directedFace value
     * @param \StructType\DirectedFacePropertyType $directedFace
     * @return \StructType\TopoSurfaceType
     */
    public function setDirectedFace(\StructType\DirectedFacePropertyType $directedFace = null)
    {
        $this->directedFace = $directedFace;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\TopoSurfaceType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
