<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoPrimitiveArrayAssociationType StructType
 * @subpackage Structs
 */
class TopoPrimitiveArrayAssociationType extends AbstractStructBase
{
    /**
     * The AbstractTopoPrimitive
     * @var \StructType\AbstractTopoPrimitiveType
     */
    public $AbstractTopoPrimitive;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for TopoPrimitiveArrayAssociationType
     * @uses TopoPrimitiveArrayAssociationType::setAbstractTopoPrimitive()
     * @uses TopoPrimitiveArrayAssociationType::setOwns()
     * @param \StructType\AbstractTopoPrimitiveType $abstractTopoPrimitive
     * @param bool $owns
     */
    public function __construct(\StructType\AbstractTopoPrimitiveType $abstractTopoPrimitive = null, $owns = null)
    {
        $this
            ->setAbstractTopoPrimitive($abstractTopoPrimitive)
            ->setOwns($owns);
    }
    /**
     * Get AbstractTopoPrimitive value
     * @return \StructType\AbstractTopoPrimitiveType|null
     */
    public function getAbstractTopoPrimitive()
    {
        return $this->AbstractTopoPrimitive;
    }
    /**
     * Set AbstractTopoPrimitive value
     * @param \StructType\AbstractTopoPrimitiveType $abstractTopoPrimitive
     * @return \StructType\TopoPrimitiveArrayAssociationType
     */
    public function setAbstractTopoPrimitive(\StructType\AbstractTopoPrimitiveType $abstractTopoPrimitive = null)
    {
        $this->AbstractTopoPrimitive = $abstractTopoPrimitive;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\TopoPrimitiveArrayAssociationType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
