<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TinType StructType
 * @subpackage Structs
 */
class TinType extends AbstractStructBase
{
    /**
     * The stopLines
     * @var \ArrayType\LineStringSegmentArrayPropertyType
     */
    public $stopLines;
    /**
     * The breakLines
     * @var \ArrayType\LineStringSegmentArrayPropertyType
     */
    public $breakLines;
    /**
     * The maxLength
     * @var \StructType\LengthType
     */
    public $maxLength;
    /**
     * The controlPoint
     * @var \StructType\ControlPoint
     */
    public $controlPoint;
    /**
     * Constructor method for TinType
     * @uses TinType::setStopLines()
     * @uses TinType::setBreakLines()
     * @uses TinType::setMaxLength()
     * @uses TinType::setControlPoint()
     * @param \ArrayType\LineStringSegmentArrayPropertyType $stopLines
     * @param \ArrayType\LineStringSegmentArrayPropertyType $breakLines
     * @param \StructType\LengthType $maxLength
     * @param \StructType\ControlPoint $controlPoint
     */
    public function __construct(\ArrayType\LineStringSegmentArrayPropertyType $stopLines = null, \ArrayType\LineStringSegmentArrayPropertyType $breakLines = null, \StructType\LengthType $maxLength = null, \StructType\ControlPoint $controlPoint = null)
    {
        $this
            ->setStopLines($stopLines)
            ->setBreakLines($breakLines)
            ->setMaxLength($maxLength)
            ->setControlPoint($controlPoint);
    }
    /**
     * Get stopLines value
     * @return \ArrayType\LineStringSegmentArrayPropertyType|null
     */
    public function getStopLines()
    {
        return $this->stopLines;
    }
    /**
     * Set stopLines value
     * @param \ArrayType\LineStringSegmentArrayPropertyType $stopLines
     * @return \StructType\TinType
     */
    public function setStopLines(\ArrayType\LineStringSegmentArrayPropertyType $stopLines = null)
    {
        $this->stopLines = $stopLines;
        return $this;
    }
    /**
     * Get breakLines value
     * @return \ArrayType\LineStringSegmentArrayPropertyType|null
     */
    public function getBreakLines()
    {
        return $this->breakLines;
    }
    /**
     * Set breakLines value
     * @param \ArrayType\LineStringSegmentArrayPropertyType $breakLines
     * @return \StructType\TinType
     */
    public function setBreakLines(\ArrayType\LineStringSegmentArrayPropertyType $breakLines = null)
    {
        $this->breakLines = $breakLines;
        return $this;
    }
    /**
     * Get maxLength value
     * @return \StructType\LengthType|null
     */
    public function getMaxLength()
    {
        return $this->maxLength;
    }
    /**
     * Set maxLength value
     * @param \StructType\LengthType $maxLength
     * @return \StructType\TinType
     */
    public function setMaxLength(\StructType\LengthType $maxLength = null)
    {
        $this->maxLength = $maxLength;
        return $this;
    }
    /**
     * Get controlPoint value
     * @return \StructType\ControlPoint|null
     */
    public function getControlPoint()
    {
        return $this->controlPoint;
    }
    /**
     * Set controlPoint value
     * @param \StructType\ControlPoint $controlPoint
     * @return \StructType\TinType
     */
    public function setControlPoint(\StructType\ControlPoint $controlPoint = null)
    {
        $this->controlPoint = $controlPoint;
        return $this;
    }
}
