<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimePeriodType StructType
 * @subpackage Structs
 */
class TimePeriodType extends AbstractStructBase
{
    /**
     * The beginPosition
     * @var \StructType\TimePositionType
     */
    public $beginPosition;
    /**
     * The begin
     * @var \StructType\TimeInstantPropertyType
     */
    public $begin;
    /**
     * The endPosition
     * @var \StructType\TimePositionType
     */
    public $endPosition;
    /**
     * The end
     * @var \StructType\TimeInstantPropertyType
     */
    public $end;
    /**
     * The duration
     * @var string
     */
    public $duration;
    /**
     * The timeInterval
     * @var \StructType\TimeIntervalLengthType
     */
    public $timeInterval;
    /**
     * Constructor method for TimePeriodType
     * @uses TimePeriodType::setBeginPosition()
     * @uses TimePeriodType::setBegin()
     * @uses TimePeriodType::setEndPosition()
     * @uses TimePeriodType::setEnd()
     * @uses TimePeriodType::setDuration()
     * @uses TimePeriodType::setTimeInterval()
     * @param \StructType\TimePositionType $beginPosition
     * @param \StructType\TimeInstantPropertyType $begin
     * @param \StructType\TimePositionType $endPosition
     * @param \StructType\TimeInstantPropertyType $end
     * @param string $duration
     * @param \StructType\TimeIntervalLengthType $timeInterval
     */
    public function __construct(\StructType\TimePositionType $beginPosition = null, \StructType\TimeInstantPropertyType $begin = null, \StructType\TimePositionType $endPosition = null, \StructType\TimeInstantPropertyType $end = null, $duration = null, \StructType\TimeIntervalLengthType $timeInterval = null)
    {
        $this
            ->setBeginPosition($beginPosition)
            ->setBegin($begin)
            ->setEndPosition($endPosition)
            ->setEnd($end)
            ->setDuration($duration)
            ->setTimeInterval($timeInterval);
    }
    /**
     * Get beginPosition value
     * @return \StructType\TimePositionType|null
     */
    public function getBeginPosition()
    {
        return $this->beginPosition;
    }
    /**
     * Set beginPosition value
     * @param \StructType\TimePositionType $beginPosition
     * @return \StructType\TimePeriodType
     */
    public function setBeginPosition(\StructType\TimePositionType $beginPosition = null)
    {
        $this->beginPosition = $beginPosition;
        return $this;
    }
    /**
     * Get begin value
     * @return \StructType\TimeInstantPropertyType|null
     */
    public function getBegin()
    {
        return $this->begin;
    }
    /**
     * Set begin value
     * @param \StructType\TimeInstantPropertyType $begin
     * @return \StructType\TimePeriodType
     */
    public function setBegin(\StructType\TimeInstantPropertyType $begin = null)
    {
        $this->begin = $begin;
        return $this;
    }
    /**
     * Get endPosition value
     * @return \StructType\TimePositionType|null
     */
    public function getEndPosition()
    {
        return $this->endPosition;
    }
    /**
     * Set endPosition value
     * @param \StructType\TimePositionType $endPosition
     * @return \StructType\TimePeriodType
     */
    public function setEndPosition(\StructType\TimePositionType $endPosition = null)
    {
        $this->endPosition = $endPosition;
        return $this;
    }
    /**
     * Get end value
     * @return \StructType\TimeInstantPropertyType|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \StructType\TimeInstantPropertyType $end
     * @return \StructType\TimePeriodType
     */
    public function setEnd(\StructType\TimeInstantPropertyType $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param string $duration
     * @return \StructType\TimePeriodType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get timeInterval value
     * @return \StructType\TimeIntervalLengthType|null
     */
    public function getTimeInterval()
    {
        return $this->timeInterval;
    }
    /**
     * Set timeInterval value
     * @param \StructType\TimeIntervalLengthType $timeInterval
     * @return \StructType\TimePeriodType
     */
    public function setTimeInterval(\StructType\TimeIntervalLengthType $timeInterval = null)
    {
        $this->timeInterval = $timeInterval;
        return $this;
    }
}
