<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeClockType StructType
 * @subpackage Structs
 */
class TimeClockType extends AbstractStructBase
{
    /**
     * The referenceEvent
     * @var \StructType\StringOrRefType
     */
    public $referenceEvent;
    /**
     * The referenceTime
     * @var string
     */
    public $referenceTime;
    /**
     * The utcReference
     * @var string
     */
    public $utcReference;
    /**
     * The dateBasis
     * @var \StructType\TimeCalendarPropertyType
     */
    public $dateBasis;
    /**
     * Constructor method for TimeClockType
     * @uses TimeClockType::setReferenceEvent()
     * @uses TimeClockType::setReferenceTime()
     * @uses TimeClockType::setUtcReference()
     * @uses TimeClockType::setDateBasis()
     * @param \StructType\StringOrRefType $referenceEvent
     * @param string $referenceTime
     * @param string $utcReference
     * @param \StructType\TimeCalendarPropertyType $dateBasis
     */
    public function __construct(\StructType\StringOrRefType $referenceEvent = null, $referenceTime = null, $utcReference = null, \StructType\TimeCalendarPropertyType $dateBasis = null)
    {
        $this
            ->setReferenceEvent($referenceEvent)
            ->setReferenceTime($referenceTime)
            ->setUtcReference($utcReference)
            ->setDateBasis($dateBasis);
    }
    /**
     * Get referenceEvent value
     * @return \StructType\StringOrRefType|null
     */
    public function getReferenceEvent()
    {
        return $this->referenceEvent;
    }
    /**
     * Set referenceEvent value
     * @param \StructType\StringOrRefType $referenceEvent
     * @return \StructType\TimeClockType
     */
    public function setReferenceEvent(\StructType\StringOrRefType $referenceEvent = null)
    {
        $this->referenceEvent = $referenceEvent;
        return $this;
    }
    /**
     * Get referenceTime value
     * @return string|null
     */
    public function getReferenceTime()
    {
        return $this->referenceTime;
    }
    /**
     * Set referenceTime value
     * @param string $referenceTime
     * @return \StructType\TimeClockType
     */
    public function setReferenceTime($referenceTime = null)
    {
        // validation for constraint: string
        if (!is_null($referenceTime) && !is_string($referenceTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceTime, true), gettype($referenceTime)), __LINE__);
        }
        $this->referenceTime = $referenceTime;
        return $this;
    }
    /**
     * Get utcReference value
     * @return string|null
     */
    public function getUtcReference()
    {
        return $this->utcReference;
    }
    /**
     * Set utcReference value
     * @param string $utcReference
     * @return \StructType\TimeClockType
     */
    public function setUtcReference($utcReference = null)
    {
        // validation for constraint: string
        if (!is_null($utcReference) && !is_string($utcReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utcReference, true), gettype($utcReference)), __LINE__);
        }
        $this->utcReference = $utcReference;
        return $this;
    }
    /**
     * Get dateBasis value
     * @return \StructType\TimeCalendarPropertyType|null
     */
    public function getDateBasis()
    {
        return $this->dateBasis;
    }
    /**
     * Set dateBasis value
     * @param \StructType\TimeCalendarPropertyType $dateBasis
     * @return \StructType\TimeClockType
     */
    public function setDateBasis(\StructType\TimeCalendarPropertyType $dateBasis = null)
    {
        $this->dateBasis = $dateBasis;
        return $this;
    }
}
