<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeCalendarEraType StructType
 * @subpackage Structs
 */
class TimeCalendarEraType extends AbstractStructBase
{
    /**
     * The referenceEvent
     * @var \StructType\StringOrRefType
     */
    public $referenceEvent;
    /**
     * The referenceDate
     * @var string
     */
    public $referenceDate;
    /**
     * The julianReference
     * @var float
     */
    public $julianReference;
    /**
     * The epochOfUse
     * @var \StructType\TimePeriodPropertyType
     */
    public $epochOfUse;
    /**
     * Constructor method for TimeCalendarEraType
     * @uses TimeCalendarEraType::setReferenceEvent()
     * @uses TimeCalendarEraType::setReferenceDate()
     * @uses TimeCalendarEraType::setJulianReference()
     * @uses TimeCalendarEraType::setEpochOfUse()
     * @param \StructType\StringOrRefType $referenceEvent
     * @param string $referenceDate
     * @param float $julianReference
     * @param \StructType\TimePeriodPropertyType $epochOfUse
     */
    public function __construct(\StructType\StringOrRefType $referenceEvent = null, $referenceDate = null, $julianReference = null, \StructType\TimePeriodPropertyType $epochOfUse = null)
    {
        $this
            ->setReferenceEvent($referenceEvent)
            ->setReferenceDate($referenceDate)
            ->setJulianReference($julianReference)
            ->setEpochOfUse($epochOfUse);
    }
    /**
     * Get referenceEvent value
     * @return \StructType\StringOrRefType|null
     */
    public function getReferenceEvent()
    {
        return $this->referenceEvent;
    }
    /**
     * Set referenceEvent value
     * @param \StructType\StringOrRefType $referenceEvent
     * @return \StructType\TimeCalendarEraType
     */
    public function setReferenceEvent(\StructType\StringOrRefType $referenceEvent = null)
    {
        $this->referenceEvent = $referenceEvent;
        return $this;
    }
    /**
     * Get referenceDate value
     * @return string|null
     */
    public function getReferenceDate()
    {
        return $this->referenceDate;
    }
    /**
     * Set referenceDate value
     * @param string $referenceDate
     * @return \StructType\TimeCalendarEraType
     */
    public function setReferenceDate($referenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($referenceDate) && !is_string($referenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceDate, true), gettype($referenceDate)), __LINE__);
        }
        $this->referenceDate = $referenceDate;
        return $this;
    }
    /**
     * Get julianReference value
     * @return float|null
     */
    public function getJulianReference()
    {
        return $this->julianReference;
    }
    /**
     * Set julianReference value
     * @param float $julianReference
     * @return \StructType\TimeCalendarEraType
     */
    public function setJulianReference($julianReference = null)
    {
        // validation for constraint: float
        if (!is_null($julianReference) && !(is_float($julianReference) || is_numeric($julianReference))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($julianReference, true), gettype($julianReference)), __LINE__);
        }
        $this->julianReference = $julianReference;
        return $this;
    }
    /**
     * Get epochOfUse value
     * @return \StructType\TimePeriodPropertyType|null
     */
    public function getEpochOfUse()
    {
        return $this->epochOfUse;
    }
    /**
     * Set epochOfUse value
     * @param \StructType\TimePeriodPropertyType $epochOfUse
     * @return \StructType\TimeCalendarEraType
     */
    public function setEpochOfUse(\StructType\TimePeriodPropertyType $epochOfUse = null)
    {
        $this->epochOfUse = $epochOfUse;
        return $this;
    }
}
