<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextmodulIndividuell StructType
 * Meta information extracted from the WSDL
 * - documentation: Über diesen Datentyp können individuelle Textmodule zusätzlich zu den LeiKa-Modulen angegeben werden.
 * @subpackage Structs
 */
class TextmodulIndividuell extends Leistungsmodul
{
    /**
     * The inhalt
     * Meta information extracted from the WSDL
     * - documentation: Textinhalt des TextmodulsDie Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $inhalt;
    /**
     * The individuellesTextmodultyp
     * Meta information extracted from the WSDL
     * - documentation: Typ des Textmoduls. Richtlinie: Bei der Umsetzung ist darauf zu achten, keine individuellen Textmodule zu definieren, welche bereits im Datentyp Leistung-Textmodul bzw. Code.Leistungstextmodul verfügbar sind.
     * @var \StructType\Code_TextmodultypIndividuell
     */
    public $individuellesTextmodultyp;
    /**
     * The weiterfuehrenderLink
     * Meta information extracted from the WSDL
     * - documentation: Weiterführende Links zum Textinhalt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $weiterfuehrenderLink;
    /**
     * Constructor method for TextmodulIndividuell
     * @uses TextmodulIndividuell::setInhalt()
     * @uses TextmodulIndividuell::setIndividuellesTextmodultyp()
     * @uses TextmodulIndividuell::setWeiterfuehrenderLink()
     * @param \StructType\String_Localized[] $inhalt
     * @param \StructType\Code_TextmodultypIndividuell $individuellesTextmodultyp
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     */
    public function __construct(array $inhalt = array(), \StructType\Code_TextmodultypIndividuell $individuellesTextmodultyp = null, array $weiterfuehrenderLink = array())
    {
        $this
            ->setInhalt($inhalt)
            ->setIndividuellesTextmodultyp($individuellesTextmodultyp)
            ->setWeiterfuehrenderLink($weiterfuehrenderLink);
    }
    /**
     * Get inhalt value
     * @return \StructType\String_Localized[]|null
     */
    public function getInhalt()
    {
        return $this->inhalt;
    }
    /**
     * This method is responsible for validating the values passed to the setInhalt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInhalt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInhaltForArrayConstraintsFromSetInhalt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textmodulIndividuellInhaltItem) {
            // validation for constraint: itemType
            if (!$textmodulIndividuellInhaltItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($textmodulIndividuellInhaltItem) ? get_class($textmodulIndividuellInhaltItem) : sprintf('%s(%s)', gettype($textmodulIndividuellInhaltItem), var_export($textmodulIndividuellInhaltItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inhalt property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inhalt value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $inhalt
     * @return \StructType\TextmodulIndividuell
     */
    public function setInhalt(array $inhalt = array())
    {
        // validation for constraint: array
        if ('' !== ($inhaltArrayErrorMessage = self::validateInhaltForArrayConstraintsFromSetInhalt($inhalt))) {
            throw new \InvalidArgumentException($inhaltArrayErrorMessage, __LINE__);
        }
        $this->inhalt = $inhalt;
        return $this;
    }
    /**
     * Add item to inhalt value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\TextmodulIndividuell
     */
    public function addToInhalt(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The inhalt property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inhalt[] = $item;
        return $this;
    }
    /**
     * Get individuellesTextmodultyp value
     * @return \StructType\Code_TextmodultypIndividuell|null
     */
    public function getIndividuellesTextmodultyp()
    {
        return $this->individuellesTextmodultyp;
    }
    /**
     * Set individuellesTextmodultyp value
     * @param \StructType\Code_TextmodultypIndividuell $individuellesTextmodultyp
     * @return \StructType\TextmodulIndividuell
     */
    public function setIndividuellesTextmodultyp(\StructType\Code_TextmodultypIndividuell $individuellesTextmodultyp = null)
    {
        $this->individuellesTextmodultyp = $individuellesTextmodultyp;
        return $this;
    }
    /**
     * Get weiterfuehrenderLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getWeiterfuehrenderLink()
    {
        return $this->weiterfuehrenderLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWeiterfuehrenderLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeiterfuehrenderLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textmodulIndividuellWeiterfuehrenderLinkItem) {
            // validation for constraint: itemType
            if (!$textmodulIndividuellWeiterfuehrenderLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($textmodulIndividuellWeiterfuehrenderLinkItem) ? get_class($textmodulIndividuellWeiterfuehrenderLinkItem) : sprintf('%s(%s)', gettype($textmodulIndividuellWeiterfuehrenderLinkItem), var_export($textmodulIndividuellWeiterfuehrenderLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     * @return \StructType\TextmodulIndividuell
     */
    public function setWeiterfuehrenderLink(array $weiterfuehrenderLink = array())
    {
        // validation for constraint: array
        if ('' !== ($weiterfuehrenderLinkArrayErrorMessage = self::validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink($weiterfuehrenderLink))) {
            throw new \InvalidArgumentException($weiterfuehrenderLinkArrayErrorMessage, __LINE__);
        }
        $this->weiterfuehrenderLink = $weiterfuehrenderLink;
        return $this;
    }
    /**
     * Add item to weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\TextmodulIndividuell
     */
    public function addToWeiterfuehrenderLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weiterfuehrenderLink[] = $item;
        return $this;
    }
}
