<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Textmodul StructType
 * Meta information extracted from the WSDL
 * - documentation: Modul zur Abbildung von Textbestandteilen von Leistungen. D.h. alle Module ohne speziell strukturiert erfasste Daten.Ein Textmodul soll pro Leistung maximal nur einmal pro Typ/Code hinzugefügt werden.
 * @subpackage Structs
 */
class Textmodul extends Leistungsmodul
{
    /**
     * The inhalt
     * Meta information extracted from the WSDL
     * - documentation: Der Textinhalt des Textmoduls. Hyperlinks sollten hier nicht oder nur in begründeten Ausnahmen verwendet werden. Links zu weiterführenden Ressourcen sollen unter "weiterfuehrenderLink" angegeben werden.Die Verwendung bestimmter
     * HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $inhalt;
    /**
     * The leikaTextmodul
     * Meta information extracted from the WSDL
     * - documentation: Angabe des entsprechenden LeiKa-Moduls (Auswahl aus Textmodulen)
     * @var \StructType\Code_Leistungstextmodul
     */
    public $leikaTextmodul;
    /**
     * The leikaTextModulAbweichendeBezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Individuelle Bezeichnung (Name) für das unter leikaTextmodul referenzierte Modul des LeiKa. Zum Beispiel "Welche Kosten fallen an?" anstatt "Kosten (Gebühren, Auslagen etc.)".
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $leikaTextModulAbweichendeBezeichnung;
    /**
     * The weiterfuehrenderLink
     * Meta information extracted from the WSDL
     * - documentation: Angabe von weiterführenden Links.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $weiterfuehrenderLink;
    /**
     * Constructor method for Textmodul
     * @uses Textmodul::setInhalt()
     * @uses Textmodul::setLeikaTextmodul()
     * @uses Textmodul::setLeikaTextModulAbweichendeBezeichnung()
     * @uses Textmodul::setWeiterfuehrenderLink()
     * @param \StructType\String_Localized[] $inhalt
     * @param \StructType\Code_Leistungstextmodul $leikaTextmodul
     * @param \StructType\String_Localized[] $leikaTextModulAbweichendeBezeichnung
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     */
    public function __construct(array $inhalt = array(), \StructType\Code_Leistungstextmodul $leikaTextmodul = null, array $leikaTextModulAbweichendeBezeichnung = array(), array $weiterfuehrenderLink = array())
    {
        $this
            ->setInhalt($inhalt)
            ->setLeikaTextmodul($leikaTextmodul)
            ->setLeikaTextModulAbweichendeBezeichnung($leikaTextModulAbweichendeBezeichnung)
            ->setWeiterfuehrenderLink($weiterfuehrenderLink);
    }
    /**
     * Get inhalt value
     * @return \StructType\String_Localized[]|null
     */
    public function getInhalt()
    {
        return $this->inhalt;
    }
    /**
     * This method is responsible for validating the values passed to the setInhalt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInhalt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInhaltForArrayConstraintsFromSetInhalt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textmodulInhaltItem) {
            // validation for constraint: itemType
            if (!$textmodulInhaltItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($textmodulInhaltItem) ? get_class($textmodulInhaltItem) : sprintf('%s(%s)', gettype($textmodulInhaltItem), var_export($textmodulInhaltItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The inhalt property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set inhalt value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $inhalt
     * @return \StructType\Textmodul
     */
    public function setInhalt(array $inhalt = array())
    {
        // validation for constraint: array
        if ('' !== ($inhaltArrayErrorMessage = self::validateInhaltForArrayConstraintsFromSetInhalt($inhalt))) {
            throw new \InvalidArgumentException($inhaltArrayErrorMessage, __LINE__);
        }
        $this->inhalt = $inhalt;
        return $this;
    }
    /**
     * Add item to inhalt value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Textmodul
     */
    public function addToInhalt(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The inhalt property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->inhalt[] = $item;
        return $this;
    }
    /**
     * Get leikaTextmodul value
     * @return \StructType\Code_Leistungstextmodul|null
     */
    public function getLeikaTextmodul()
    {
        return $this->leikaTextmodul;
    }
    /**
     * Set leikaTextmodul value
     * @param \StructType\Code_Leistungstextmodul $leikaTextmodul
     * @return \StructType\Textmodul
     */
    public function setLeikaTextmodul(\StructType\Code_Leistungstextmodul $leikaTextmodul = null)
    {
        $this->leikaTextmodul = $leikaTextmodul;
        return $this;
    }
    /**
     * Get leikaTextModulAbweichendeBezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getLeikaTextModulAbweichendeBezeichnung()
    {
        return $this->leikaTextModulAbweichendeBezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setLeikaTextModulAbweichendeBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeikaTextModulAbweichendeBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeikaTextModulAbweichendeBezeichnungForArrayConstraintsFromSetLeikaTextModulAbweichendeBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textmodulLeikaTextModulAbweichendeBezeichnungItem) {
            // validation for constraint: itemType
            if (!$textmodulLeikaTextModulAbweichendeBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($textmodulLeikaTextModulAbweichendeBezeichnungItem) ? get_class($textmodulLeikaTextModulAbweichendeBezeichnungItem) : sprintf('%s(%s)', gettype($textmodulLeikaTextModulAbweichendeBezeichnungItem), var_export($textmodulLeikaTextModulAbweichendeBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leikaTextModulAbweichendeBezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leikaTextModulAbweichendeBezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $leikaTextModulAbweichendeBezeichnung
     * @return \StructType\Textmodul
     */
    public function setLeikaTextModulAbweichendeBezeichnung(array $leikaTextModulAbweichendeBezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($leikaTextModulAbweichendeBezeichnungArrayErrorMessage = self::validateLeikaTextModulAbweichendeBezeichnungForArrayConstraintsFromSetLeikaTextModulAbweichendeBezeichnung($leikaTextModulAbweichendeBezeichnung))) {
            throw new \InvalidArgumentException($leikaTextModulAbweichendeBezeichnungArrayErrorMessage, __LINE__);
        }
        $this->leikaTextModulAbweichendeBezeichnung = $leikaTextModulAbweichendeBezeichnung;
        return $this;
    }
    /**
     * Add item to leikaTextModulAbweichendeBezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Textmodul
     */
    public function addToLeikaTextModulAbweichendeBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The leikaTextModulAbweichendeBezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leikaTextModulAbweichendeBezeichnung[] = $item;
        return $this;
    }
    /**
     * Get weiterfuehrenderLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getWeiterfuehrenderLink()
    {
        return $this->weiterfuehrenderLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWeiterfuehrenderLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeiterfuehrenderLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textmodulWeiterfuehrenderLinkItem) {
            // validation for constraint: itemType
            if (!$textmodulWeiterfuehrenderLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($textmodulWeiterfuehrenderLinkItem) ? get_class($textmodulWeiterfuehrenderLinkItem) : sprintf('%s(%s)', gettype($textmodulWeiterfuehrenderLinkItem), var_export($textmodulWeiterfuehrenderLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     * @return \StructType\Textmodul
     */
    public function setWeiterfuehrenderLink(array $weiterfuehrenderLink = array())
    {
        // validation for constraint: array
        if ('' !== ($weiterfuehrenderLinkArrayErrorMessage = self::validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink($weiterfuehrenderLink))) {
            throw new \InvalidArgumentException($weiterfuehrenderLinkArrayErrorMessage, __LINE__);
        }
        $this->weiterfuehrenderLink = $weiterfuehrenderLink;
        return $this;
    }
    /**
     * Add item to weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Textmodul
     */
    public function addToWeiterfuehrenderLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weiterfuehrenderLink[] = $item;
        return $this;
    }
}
